<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_TommusRhodus_Hero_Header_CTA_Block extends Widget_Base {
	
	//Return Class Name
	public function get_name() {
		return 'tommusrhodus-hero-header-cta-block';
	}
	
	//Return Block Title (for blocks list)
	public function get_title() {
		return esc_html__( 'Hero Header CTA', 'tr-framework' );
	}
	
	//Return Block Icon (for blocks list)
	public function get_icon() {
		return 'eicon-call-to-action';
	}
	
	public function get_categories() {
		return [ 'uptime-elements' ];
	}

	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_layout', [
				'label' => esc_html__( 'Layout', 'tr-framework' ),
			]
		);
		
		$this->add_control(
			'layout', [
				'label'   => __( 'Hero Header Layout', 'tr-framework' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'dark-primary-3',
				'label_block' => true,
				'options' => [
					'dark-primary-3'         	=> esc_html__( 'Dark Primary 3, Text + Form', 'tr-framework' ),					
					'image-bg-text-above'		=> esc_html__( 'Image Background, Text Above Form', 'tr-framework' ),
				],
			]
		);
		
		$this->add_control(
			'divider', [
				'label'       => __( 'Bottom Divider Shape', 'tr-framework' ),
				'type'        => Controls_Manager::SELECT,
				'default'     => 'none',
				'options'     => tommusrhodus_get_divider_layouts(),
				'label_block' => true
			]
		);
		
		$this->end_controls_section();
		
		$this->start_controls_section(
			'section_content', [
				'label' => esc_html__( 'Content', 'tr-framework' ),
			]
		);
		
		$this->add_control(
			'image', [
				'label'      => __( 'Image', 'tr-framework' ),
				'type'       => Controls_Manager::MEDIA,
				'default' => [
					'url' => '',
				],
			]
		);
		
		$this->add_control(
			'content', [
				'label'       => __( 'Content', 'tr-framework' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => ''
			]
		);

		$this->add_control(
			'cta_content', [
				'label'       => __( 'CTA Content', 'tr-framework' ),
				'type'        => Controls_Manager::WYSIWYG,
				'default'     => ''
			]
		);

		$this->end_controls_section();

	}
	
	/**
	 * Whether the reload preview is required or not.
	 *
	 * Used to determine whether the reload preview is required.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return bool Whether the reload preview is required.
	 */
	public function is_reload_preview_required() {
		return true;
	}

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		
		if( 'dark-primary-3' == $settings['layout'] ){
		
			echo '
				<section class="bg-primary-3 has-divider text-light o-hidden">
					<div class="container layer-2">
						<div class="row justify-content-center pt-lg-5">
							<div class="col-xl-5 col-lg-6 col-md-7 text-center text-lg-left mb-5 mb-lg-0">
								'. $settings['content'] .'
							</div>
							<div class="col">
								<div class="row justify-content-center">
									<div class="col-xl-8 col-md-10">
										'. $settings['cta_content'] .'
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="decoration-wrapper d-none d-sm-block">
						<div data-jarallax-element="0 50">
							<div class="decoration top middle-y scale-5">
								<svg class="bg-primary-2" width="183" height="166" viewBox="0 0 183 166" fill="none" xmlns="http://www.w3.org/2000/svg">
									<path d="M2.34805 65.6701C4.02805 62.9901 5.56905 60.211 7.41605 57.652C10.82 52.939 14.734 48.636 18.627 44.322C21.811 40.794 24.9 37.181 28.08 33.65C30.619 30.831 32.879 27.721 36.068 25.554C39.035 23.539 42.066 21.62 45.039 19.616C46.439 18.674 47.812 17.682 49.123 16.624C51.525 14.687 54.035 12.972 56.996 11.982C57.787 11.717 58.5371 11.285 59.2561 10.847C63.3111 8.36802 67.328 5.82603 71.408 3.38703C73.033 2.41503 74.7361 1.53704 76.4881 0.824045C78.4981 0.00604486 80.615 -0.0229468 82.701 0.670053C84.805 1.36905 86.912 2.05405 88.994 2.81205C90.217 3.25705 91.426 3.55605 92.701 3.15705C94.228 2.67905 95.5971 3.14904 96.9921 3.72804C99.4631 4.75604 101.484 6.48703 103.691 7.92603C104.574 8.50203 105.353 9.24603 106.257 9.77903C107.429 10.469 108.624 11.197 109.905 11.604C112.95 12.57 115.751 13.945 118.466 15.634C124.386 19.315 130.482 22.6901 137.122 24.9461C141.015 26.2681 144.968 27.425 148.802 28.897C153.036 30.522 157.224 32.289 161.009 34.866C162.577 35.934 164.195 36.928 165.802 37.937C171.439 41.473 175.253 46.641 178.368 52.335C180.1 55.5 180.626 59.127 181.403 62.633C182.262 66.502 182.116 70.416 181.868 74.311C181.587 78.733 181.095 83.142 180.665 87.554C180.462 89.618 179.534 91.337 178.192 92.927C175.192 96.484 172.45 100.218 170.514 104.504C169.549 106.642 168.932 108.863 168.332 111.109C167.514 114.168 166.631 117.2 165.352 120.117C163.209 124.994 160.215 129.302 156.885 133.411C156.498 133.89 156.188 134.472 155.996 135.057C155.039 137.993 153.416 140.578 151.975 143.28C149.35 148.2 145.637 152.224 142.088 156.405C141.611 156.967 141.123 157.548 140.539 157.985C136.902 160.704 133.254 163.385 128.863 164.86C126.806 165.552 124.752 165.891 122.634 165.534C120.347 165.149 117.966 164.899 115.843 164.048C113.527 163.117 111.435 161.605 109.294 160.267C107.773 159.316 106.386 158.149 104.851 157.226C101.417 155.162 97.923 153.198 94.464 151.177C93.37 150.539 92.3001 149.863 91.2301 149.187C90.7851 148.904 90.4021 148.509 89.9331 148.281C85.2771 146.008 81.023 143.033 76.49 140.568C71.861 138.051 67.103 135.705 61.888 134.538C61.374 134.423 60.837 134.338 60.361 134.126C54.332 131.453 47.812 130.439 41.547 128.568C37.799 127.449 34.072 126.33 30.547 124.58C26.953 122.795 23.2871 121.148 19.6391 119.475C16.4031 117.991 13.774 115.777 11.504 113.057C9.25404 110.358 7.32204 107.492 6.06804 104.188C4.82404 100.913 3.92305 97.569 3.70305 94.057C3.63705 93.004 3.53704 91.946 3.33804 90.912C2.34204 85.728 1.53504 80.525 0.926042 75.276C0.531042 71.872 1.00605 68.7731 2.34805 65.6701ZM57.891 130.289C57.84 130.228 57.791 130.168 57.741 130.107C57.682 130.158 57.5811 130.203 57.5751 130.257C57.5711 130.312 57.657 130.416 57.714 130.422C57.766 130.429 57.83 130.338 57.891 130.289ZM111.725 160.38C111.678 160.322 111.635 160.227 111.582 160.22C111.531 160.213 111.469 160.302 111.412 160.349C111.459 160.406 111.502 160.502 111.555 160.507C111.608 160.512 111.668 160.426 111.725 160.38ZM141.531 85.2951L141.57 85.501L141.736 85.369L141.531 85.2951Z"
								fill="black" />
								</svg>
							</div>
						</div>
					</div>';

					if(!( 'none' == $settings['divider'] )){	
						echo tommusrhodus_svg_dividers_pluck( $settings['divider'], '' );		
					}
				
			echo '</section>';
			
		} elseif( 'image-bg-text-above' == $settings['layout'] ){
		
			echo '
				<section class="bg-primary-3 jarallax min-vh-80 d-flex flex-column justify-content-center pb-0 o-hidden" data-overlay data-jarallax data-speed="0.2">
					
					'. wp_get_attachment_image( $settings['image']['id'], 'full', 0, array( 'class' => 'jarallax-img opacity-30' ) ) .'
			      
					<div class="container py-5 position-relative">
						<div class="row">
							<div class="col-xl-6 col-lg-7 col-md-9">
								'. $settings['content'] .'
							</div>
						</div>
						<div class="row mt-4">
							<div class="col">
								'. $settings['cta_content'] .'
							</div>
						</div>
					</div>
					<div class="decoration-wrapper">
					    <div class="decoration bottom left scale-2 flip-y d-none d-xl-block" data-jarallax-element="50">
					      	<svg xmlns="http://www.w3.org/2000/svg" width="81" height="99" viewBox="0 0 81 99" fill="none" class="bg-white" data-src="assets/img/decorations/deco-dots-4.svg" xmlns:xlink="http://www.w3.org/1999/xlink">
								<path d="M16.512 39.034C15.694 39.503 14.793 39.858 14.094 40.452C12.276 41.993 10.356 43.475 8.82596 45.278C6.21296 48.36 6.58998 51.078 9.57798 54.153C10.094 54.685 10.955 54.907 11.685 55.194C12.044 55.337 12.476 55.28 12.867 55.352C15.017 55.748 15.705 56.688 15.555 59.035C11.016 60.872 7.36398 59.407 4.22098 55.993C2.15998 53.756 0.741962 51.231 0.661962 48.11C0.632962 46.994 0.790977 45.962 1.37098 44.914C3.54698 40.972 6.52296 37.87 10.412 35.592C11.707 34.833 13.039 34.918 14.351 35.188C15.306 35.385 15.997 36.129 16.206 37.163C16.34 37.815 16.422 38.479 16.512 39.034Z" fill="black"></path>
								<path d="M15.697 74.223C12.558 75.928 10.693 78.761 9.33598 81.818C7.54498 85.852 9.06098 90.272 14.078 90.917C14.887 91.021 15.717 91.46 16.394 91.946C17.511 92.749 17.462 92.817 17.347 94.582C14.38 95.921 11.482 95.849 8.72196 94.045C7.45596 93.218 6.21997 92.335 5.04597 91.382C1.89797 88.829 0.949985 81.801 2.99699 78.751C4.01799 77.23 4.76297 75.515 5.83497 74.034C7.72997 71.419 10.22 70.101 13.702 71.617C14.943 72.155 15.049 73.297 15.697 74.223Z" fill="black"></path>
								<path d="M78.5449 75.006C76.3729 74.601 75.3419 76.242 74.1429 77.555C72.8619 78.959 72.1569 80.623 72.2269 82.559C72.3869 87.028 74.3889 90.526 78.0839 92.942C79.2399 93.698 79.3539 94.837 80.1699 95.958C79.5739 95.958 79.1369 95.825 78.8579 95.978C76.0829 97.503 74.0079 96.236 72.0439 94.367C70.2509 92.66 68.4229 91.002 67.2859 88.732C66.0829 86.332 65.3249 83.839 65.5929 81.135C66.0289 76.765 68.6159 73.762 71.8999 71.146C73.3389 70 74.8039 70.028 76.3999 70.414C77.5559 70.692 78.1069 71.489 78.2359 72.637C78.3159 73.379 78.4279 74.121 78.5449 75.006Z" fill="black"></path>
								<path d="M50.3418 83.795C47.8708 83.591 45.2398 83.449 42.7048 84.279C41.0388 88.606 42.7048 93.074 46.9178 95.201C48.1448 95.82 49.0408 96.512 49.3608 98.029C48.3408 98.302 47.3058 98.584 46.2688 98.859C45.2998 99.118 44.3958 98.97 43.4818 98.543C37.4038 95.701 33.8938 88.395 35.5428 81.908C35.7188 81.217 36.0308 80.558 36.2988 79.892C36.6208 79.089 37.2028 78.615 38.0698 78.451C41.0778 77.885 44.0858 77.664 47.1268 78.22C48.5698 78.485 49.5718 79.389 50.4468 80.41C51.2928 81.396 51.4728 82.543 50.3418 83.795Z" fill="black"></path>
								<path d="M78.367 7.67896C76.728 7.85196 75.308 8.00099 73.888 8.15199C72.019 8.34999 70.921 9.27497 70.372 11.176C69.458 14.353 69.804 17.353 71.183 20.254C71.49 20.9 72.251 21.386 72.896 21.802C74.689 22.958 76.613 23.942 77.738 26.096C75.463 27.089 73.3 27.21 71.023 26.032C65.492 23.173 63.347 18.18 63.968 12.031C64.157 10.158 64.874 8.31997 65.493 6.51597C66.048 4.90197 67.288 3.77699 68.946 3.48899C70.899 3.14999 72.905 3.07497 74.891 2.98597C75.942 2.93897 76.723 3.57297 77.149 4.50397C77.604 5.49397 77.938 6.53796 78.367 7.67896Z" fill="black"></path>
								<path d="M45.898 11.393C44.492 10.616 44.472 10.618 43.916 11.645C42.529 14.197 42.822 16.754 44.828 18.882C45.478 19.571 46.219 20.213 47.016 20.72C48.481 21.652 49.954 22.528 50.192 24.534C49.585 24.68 48.784 24.712 48.153 25.056C46.801 25.793 45.633 25.606 44.323 24.907C41.643 23.479 39.428 21.542 37.858 18.984C36.092 16.107 35.942 12.919 36.899 9.745C37.524 7.676 39.237 6.54302 41.2 5.90702C42.944 5.34102 44.739 4.91199 46.532 4.51999C48.641 4.05999 50.067 4.95502 50.714 7.04902C50.923 7.72402 51.066 8.42101 51.304 9.36701C50.204 9.76101 49.103 10.138 48.017 10.549C47.292 10.823 46.589 11.147 45.876 11.449L45.898 11.393Z" fill="black"></path>
								<path d="M19.6431 5.52198C18.6041 5.46998 17.909 5.46799 17.219 5.39399C15.08 5.16299 13.449 6.00099 12.369 7.80299C11.473 9.29899 10.721 10.88 9.90007 12.434C10.222 12.967 10.517 13.344 10.697 13.77C11.25 15.085 12.349 15.408 13.611 15.439C14.166 15.452 14.722 15.377 15.279 15.369C17.363 15.334 18.3261 16.139 18.6771 18.216C18.7301 18.522 18.7101 18.839 18.7241 19.13C13.6791 21.07 8.77708 19.623 5.57808 16.217C4.24008 14.791 3.58807 12.961 3.85307 10.912C4.19307 8.30596 5.33908 6.02299 6.79408 3.91099C7.83508 2.39799 9.59309 1.80197 11.2391 1.23597C12.4271 0.826969 13.739 0.693967 15.007 0.614967C17.064 0.485967 18.028 1.20798 18.757 3.16498C19.018 3.86498 19.2811 4.56298 19.6431 5.52198Z" fill="black"></path>
								<path d="M44.8359 43.951C44.5839 44.067 44.4469 44.168 44.2969 44.193C40.0179 44.92 39.9039 48.017 41.3909 51.291C42.1799 53.03 43.8169 54.395 45.1229 55.884C45.5369 56.354 46.0839 56.738 46.6349 57.048C48.2289 57.946 49.4869 59.055 49.4079 61.244C48.3509 61.41 47.1399 61.677 45.9199 61.754C45.4219 61.787 44.8589 61.477 44.3909 61.209C40.5649 59.016 37.5139 55.98 35.4109 52.143C33.4579 48.585 33.1489 44.837 35.5809 41.295C36.9579 39.289 39.1669 38.775 41.4309 38.563C42.2079 38.49 42.7529 38.969 43.1599 39.637C43.9489 40.933 44.6229 42.266 44.8359 43.951Z" fill="black"></path>
								<path d="M76.0799 56.7771C73.8919 57.3361 71.6839 57.078 69.5139 56.634C67.7349 56.269 66.5409 54.89 65.9769 53.335C64.9499 50.503 63.8829 47.5892 63.5389 44.6272C63.0189 40.1442 65.2439 37.073 70.0369 36.672C70.5139 36.632 70.9939 36.615 71.4709 36.621C74.4729 36.654 75.3849 37.559 75.6639 40.847C74.8769 40.847 74.0979 40.84 73.3179 40.848C70.7069 40.875 69.2299 42.4121 69.6129 44.9371C69.9199 46.9721 70.4179 48.985 70.9449 50.978C71.2749 52.235 72.1329 52.87 73.5349 53.043C76.1739 53.373 76.5329 54.0101 76.0799 56.7771Z" fill="black"></path>
								</svg>
							</div>
						    <div class="decoration bottom right scale-3" data-jarallax-element="80">
						      	<svg xmlns="http://www.w3.org/2000/svg" width="43" height="122" viewBox="0 0 43 122" fill="none" class="bg-primary-2" data-src="assets/img/decorations/deco-blob-13.svg" xmlns:xlink="http://www.w3.org/1999/xlink">
									<path d="M27.7833 0.279065C31.5153 -0.395935 34.1643 0.647081 35.8243 3.52708C37.3013 3.75308 38.6543 3.75507 39.8533 4.18507C42.1543 5.01007 42.9763 6.54608 42.4253 8.85508C41.9003 11.0481 41.2363 13.2141 40.5173 15.3541C39.3333 18.8831 38.0523 22.3801 36.8223 25.8941C36.5623 26.6401 36.3473 27.4031 36.1253 28.1161C37.0183 29.7191 37.8983 31.1721 38.6433 32.6931C38.9753 33.3751 39.2763 34.2291 39.1643 34.9391C38.7993 37.2861 38.4123 39.6531 37.7263 41.9191C34.3003 53.2441 30.6563 64.5041 27.3223 75.8571C24.0643 86.9611 21.6093 98.2541 20.5933 109.813C20.3373 112.721 20.3023 115.648 20.1133 118.563C20.0643 119.327 19.8203 120.077 19.6813 120.759C15.5443 121.634 15.1673 121.063 12.5563 118.159C10.5703 115.952 10.0543 113.611 9.89033 110.991C9.78533 109.283 9.15631 107.965 7.99531 106.752C5.98531 104.652 4.13033 102.404 2.07933 100.35C1.36233 99.6311 0.903309 98.9591 0.886309 97.9751C0.820309 94.3911 0.722321 90.8071 0.698321 87.2231C0.682321 84.7301 1.61831 82.2831 0.753314 79.7161C0.466314 78.8631 1.1893 77.7051 1.3173 76.6701C1.5593 74.6961 1.55332 72.6821 1.92232 70.7361C2.96332 65.2691 4.04931 59.8211 5.40431 54.4081C7.37531 46.5491 9.58832 38.7701 11.8923 31.0121C12.5353 28.8511 13.2773 26.7081 14.1303 24.6221C16.2923 19.3441 18.5343 14.0991 20.7713 8.85109C21.0273 8.24809 21.3243 7.49607 21.8303 7.19307C24.5723 5.55607 25.8093 2.64406 27.7833 0.279065Z" fill="black"></path>
								</svg>
				    		</div>
					  </div>
					';

					if(!( 'none' == $settings['divider'] )){	
						echo tommusrhodus_svg_dividers_pluck( $settings['divider'], '' );		
					}
				
			echo '</section>';
			
		}
		
	}

}

// Register our new widget
Plugin::instance()->widgets_manager->register_widget_type( new Widget_TommusRhodus_Hero_Header_CTA_Block() );