<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_TommusRhodus_Iphone_Screenshot_Block extends Widget_Base {
	
	//Return Class Name
	public function get_name() {
		return 'tommusrhodus-iphone-screenshot-block';
	}
	
	//Return Block Title (for blocks list)
	public function get_title() {
		return esc_html__( 'iPhone Screenshot', 'tr-framework' );
	}
	
	//Return Block Icon (for blocks list)
	public function get_icon() {
		return 'eicon-device-mobile';
	}
	
	public function get_categories() {
		return [ 'uptime-elements' ];
	}

	protected function _register_controls() {

		$this->start_controls_section(
			'section_content', [
				'label' => esc_html__( 'Content', 'tr-framework' ),
			]
		);

		$this->add_control(
			'layout', [
				'label'   => __( 'Layout', 'tr-framework' ),
				'type'    => Controls_Manager::SELECT,
				'default' => '1',
				'label_block' => true,
				'options' => [
					'1'          	=> esc_html__( 'Decoration 1', 'tr-framework' ),
					'2'         	=> esc_html__( 'Decoration 2', 'tr-framework' ),
				],
			]
		);
		
		$this->add_control(
			'image', [
				'label'      => __( 'Screenshot - (Upload a 500 x 1083 image size for best results)', 'tr-framework' ),
				'type'       => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->end_controls_section();

	}

	protected function render() {
		
		$settings = $this->get_settings_for_display();
		$url      =  wp_get_attachment_image_src( $settings['image']['id'], 'full' );
		
		if( '1' == $settings['layout'] ) {

			echo '
				<div>
					<div class="mobile-screenshot rotate-left layer-1">
						'. wp_get_attachment_image( $settings['image']['id'], 'large', 0 ) .'
					  	<img src="'. get_template_directory_uri() .'/style/img/iphone-xr.svg" alt="iPhone">
					</div>
					<div class="decoration middle-y left scale-2">
					  <svg class="bg-primary-2" width="184" height="81" viewBox="0 0 184 81" fill="none" xmlns="http://www.w3.org/2000/svg">
					    <path d="M106.27 57.509C107.217 57.164 108.159 56.534 109.112 56.514C131.21 56.053 153.307 55.655 175.405 55.26C176.436 55.241 177.485 55.2749 178.501 55.4339C181.522 55.9059 183.179 57.506 183.296 59.944C183.441 62.993 181.905 65.768 179.353 66.506C177.207 67.125 174.972 67.5199 172.748 67.7829C165.721 68.6189 158.678 69.3429 151.643 70.1189C150.801 70.2129 149.967 70.369 148.973 70.519C148.42 71.853 148.049 73.185 147.356 74.32C146.35 75.97 145.002 76.9309 142.811 77.1789C129.262 78.7099 115.709 79.878 102.051 79.743C94.852 79.673 87.647 80.113 80.442 80.155C78.249 80.168 76.051 79.3679 73.854 79.3699C58.645 79.3799 43.624 77.3949 28.614 75.2739C21.452 74.2619 14.298 73.169 7.16705 71.962C2.85304 71.233 0.98504 69.2959 0.67704 65.7789C0.41504 62.8019 1.99504 60.763 4.96604 60.406C5.98404 60.283 7.03203 60.427 8.06803 60.463C15.099 60.706 22.132 60.9529 29.246 60.7839C26.967 60.4059 24.685 60.049 22.412 59.644C20.898 59.373 19.318 59.238 17.906 58.687C14.812 57.48 14.162 55.958 14.906 52.528C15.541 49.603 16.82 48.607 20.008 48.556C24.824 48.48 29.643 48.404 34.315 48.329C34.555 47.587 34.848 47.089 34.737 46.97C31.716 43.749 30.706 39.074 26.985 36.35C25.243 35.074 24.897 33.1589 25.481 31.2279C26.059 29.3219 27.395 27.9259 29.452 27.5409C31.118 27.2289 32.815 27.0829 34.556 26.8559C35.038 24.1809 33.949 22.627 31.806 21.777C24.55 18.896 23.81 16.9359 24.931 10.3129C23.88 9.36394 22.745 8.33794 21.464 7.17994C21.505 6.28094 21.585 5.25796 21.593 4.23396C21.611 2.26896 22.779 1.44394 24.54 1.34294C29.702 1.04794 34.888 0.391959 40.028 0.638959C51.753 1.20096 63.444 2.41096 75.167 2.99696C89.489 3.71296 103.829 4.05895 118.161 4.56395C126.96 4.87495 135.763 5.10595 144.556 5.55995C146.368 5.65295 148.41 6.18895 149.867 7.20695C152.109 8.77295 154.41 9.34295 157.053 9.66395C159.352 9.94295 161.547 11.075 164.133 11.946C163.488 15.223 162.938 18.025 162.309 21.234C163.909 21.448 165.395 21.697 166.891 21.829C167.918 21.92 168.969 21.7809 169.998 21.8649C173.602 22.1599 175.807 23.5679 176.049 25.6579C176.416 28.8279 174.061 31.74 170.502 32.515C165.959 33.504 165.959 33.504 164.998 38.858C166.56 38.929 168.082 38.9539 169.598 39.0759C172.922 39.3429 174.436 40.5219 174.766 43.0159C175.245 46.6299 173.711 49.55 170.557 50.302C167.039 51.142 163.461 51.9369 159.866 52.2179C143.854 53.4649 127.827 54.5169 111.807 55.6539C109.809 55.7969 107.543 55.223 106.27 57.523C104.791 55.748 103.09 56.222 101.452 56.902C103.002 57.101 104.635 57.305 106.27 57.509ZM152.543 38.5669C152.533 38.9539 152.522 39.3399 152.512 39.7269C154.104 39.6279 155.696 39.529 157.287 39.431C157.291 39.304 157.295 39.176 157.299 39.048C155.715 38.888 154.129 38.7279 152.543 38.5669ZM162.824 38.9179C162.697 38.8329 162.572 38.685 162.443 38.681C162.298 38.677 162.152 38.806 162.005 38.876C162.193 39.021 162.38 39.1649 162.567 39.3089C162.652 39.1789 162.738 39.0489 162.824 38.9179ZM113.043 20.75L112.957 20.466L112.6 20.627L113.043 20.75Z"
					    fill="black" />
					  </svg>

					</div>
				</div>
			';

		} elseif( '2' == $settings['layout'] ) {

			echo '
				<div class="col-md">
					<div class="mobile-screenshot rotate-left layer-2">
						'. wp_get_attachment_image( $settings['image']['id'], 'large', 0 ) .'
					  	<img src="'. get_template_directory_uri() .'/style/img/iphone-xr.svg" alt="iPhone">
					</div>
					<div class="decoration-wrapper d-none d-md-block">
						<div class="decoration middle-y scale-2" data-jarallax-element="40">
							<svg class="bg-primary-2" width="122" height="159" viewBox="0 0 122 159" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M43.3108 158.858C40.6218 158.483 36.6428 158.086 32.7288 157.341C28.0118 156.445 23.4148 155.108 19.0668 152.959C13.3088 150.112 8.31079 146.303 4.40679 141.229C1.07479 136.896 -0.380207 131.883 0.168793 126.365C0.270793 125.334 0.340783 124.288 0.285783 123.256C-0.0442177 116.983 0.760791 110.818 1.89479 104.67C2.70679 100.272 3.49979 95.862 4.07279 91.428C4.44979 88.507 4.4598 85.534 4.5568 82.582C4.6658 79.229 4.61579 75.872 4.77379 72.522C4.90479 69.731 5.29379 66.952 5.46479 64.162C5.76579 59.223 6.00778 54.28 6.23578 49.337C6.36878 46.465 6.29779 43.579 6.54479 40.719C7.07379 34.544 9.1428 28.896 12.6698 23.781C14.2108 21.548 15.6228 19.227 17.1598 16.992C18.8648 14.51 21.0678 12.511 23.7648 11.197C30.0168 8.15502 36.1088 4.77203 42.6608 2.36703C44.1038 1.83703 45.5008 1.46702 47.0728 1.48202C48.7348 1.50002 50.4318 1.28303 52.0588 0.923029C55.2108 0.226028 58.0978 1.07101 60.9238 2.23501C68.2928 5.27001 74.5858 9.82801 79.8258 15.839C80.9798 17.163 82.2148 18.418 83.3938 19.721C86.5828 23.239 89.0248 27.236 91.2488 31.423C96.8208 41.91 99.6038 53.347 102.804 64.644C105.115 72.806 107.562 80.9 111.333 88.547C114.78 95.535 117.247 102.858 118.53 110.582C118.96 113.166 120.063 115.631 120.661 118.195C121.202 120.518 121.557 122.894 121.825 125.265C121.938 126.265 121.669 127.325 121.479 128.339C120.834 131.806 118.846 134.257 115.741 135.874C110.286 138.716 104.977 141.846 99.1958 144.04C97.4068 144.719 95.6798 145.578 93.9658 146.436C89.2058 148.816 84.1218 150.163 78.9738 151.382C75.4778 152.21 72.0718 153.404 68.5888 154.305C63.9498 155.505 59.3098 156.744 54.6098 157.651C51.3318 158.284 47.9488 158.387 43.3108 158.858Z"
							fill="black" />
							</svg>
						</div>
						<div class="decoration left top scale-2">
							<svg class="bg-primary" width="114" height="64" viewBox="0 0 114 64" fill="none" xmlns="http://www.w3.org/2000/svg">
							<path d="M73.32 8.86801C73.459 7.62901 72.664 7.25601 71.906 6.76901C70.867 6.10101 70.59 5.277 71.031 4.345C71.222 3.945 71.58 3.52399 71.969 3.33499C73.746 2.47299 76.209 3.20301 77.276 4.85901C77.698 5.51701 77.764 6.25802 77.266 6.87702C76.352 8.01402 75.258 8.90001 73.32 8.86801Z"
							fill="black" />
							<path d="M33.5251 51.6231C32.8901 51.3521 32.2261 51.1311 31.6251 50.7981C30.5961 50.2291 29.8591 49.4331 29.9791 48.1321C30.0831 46.9981 31.0281 46.0351 32.3131 45.7621C32.5471 45.7121 32.7801 45.6531 33.0181 45.6251C34.1571 45.4901 34.8851 45.9071 35.2481 46.9691C35.5371 47.8111 35.6291 48.6821 35.3671 49.5591C35.1191 50.3861 34.8261 50.7141 33.5251 51.6231Z"
							fill="black" />
							<path d="M3.47102 38.293C3.28302 38.205 2.79302 38.133 2.59002 37.854C1.75002 36.698 0.916028 35.502 0.709028 34.047C0.582028 33.168 1.12103 32.389 1.85003 32.159C2.72303 31.885 3.61003 31.74 4.24803 32.605C4.86303 33.436 5.44502 34.295 5.98002 35.179C6.42302 35.909 6.49802 36.75 5.98002 37.446C5.43202 38.186 4.63102 38.556 3.47102 38.293Z"
							fill="black" />
							<path d="M67.549 22.483C67.445 22.721 67.2249 23.225 67.0039 23.7311C66.5509 24.7751 64.135 25.134 63.51 24.034C63.164 23.424 62.795 22.809 62.571 22.15C62.307 21.368 62.7659 20.481 63.5589 20.271C64.3169 20.071 65.121 19.966 65.907 19.967C67.271 19.969 67.865 20.8 67.549 22.483Z"
							fill="black" />
							<path d="M113.014 61.366C112.778 62.277 112.307 62.954 111.313 63.154C110.467 63.323 109.659 63.007 109.295 62.258C108.984 61.621 108.719 60.96 108.49 60.29C108.24 59.564 108.351 58.879 108.888 58.29C109.443 57.681 110.148 57.632 110.87 57.811C112.268 58.155 113.34 59.966 113.014 61.366Z"
							fill="black" />
							<path d="M77.145 37.633C77.024 37.16 77.006 36.559 76.731 36.115C76.016 34.961 76.557 34.14 77.311 33.351C77.944 32.688 78.721 32.651 79.52 32.996C80.547 33.439 81.223 34.154 81.262 35.35C81.305 36.698 80.594 37.668 79.283 37.959C78.568 38.118 77.859 38.126 77.145 37.633ZM79.16 34.699C79.01 34.366 78.969 34.112 78.818 33.978C78.531 33.719 78.056 33.958 77.957 34.434C77.918 34.622 78.053 34.848 78.107 35.057C78.438 34.945 78.768 34.833 79.16 34.699Z"
							fill="black" />
							<path d="M20.1408 2.24493C19.9418 3.29493 19.8318 4.24094 19.5608 5.13894C19.4088 5.63894 19.0378 6.10193 18.6738 6.49993C18.2758 6.93693 17.7188 7.04993 17.1448 6.84093C16.5428 6.62293 16.3168 6.10692 16.2898 5.53292C16.2688 5.06392 16.3778 4.58994 16.4228 4.11794C16.4678 3.64594 16.5828 3.16294 16.5228 2.70394C16.4528 2.16194 16.1598 1.58792 16.8118 1.25292C17.4618 0.918921 18.1768 0.801922 18.8448 1.22292C19.2418 1.47292 19.5878 1.80293 20.1408 2.24493Z"
							fill="black" />
							<path d="M23.2341 25.618C24.1191 26.151 24.435 26.944 24.58 27.828C24.73 28.752 24.307 29.665 23.58 30.052C22.793 30.472 22.0041 30.371 21.3551 29.843C20.8821 29.458 20.466 28.929 20.201 28.379C19.627 27.184 20.1251 26.191 21.4371 25.85C22.0351 25.693 22.6721 25.686 23.2341 25.618Z"
							fill="black" />
							<path d="M53.8851 37.898C53.8231 38.16 53.7891 38.316 53.7461 38.469C53.3441 39.94 52.426 40.185 51.365 39.093C51.033 38.751 50.7011 38.396 50.4451 37.997C49.6231 36.716 50.181 35.248 51.636 34.79C52.845 34.41 53.9041 35.085 53.9821 36.337C54.0181 36.89 53.9161 37.449 53.8851 37.898Z"
							fill="black" />
							<path d="M96.3362 23.504C96.6952 24.849 96.9922 25.958 97.3112 27.15C96.9012 27.557 96.5022 28.055 96.0062 28.419C95.2012 29.007 94.0222 28.583 93.6902 27.628C93.3722 26.714 93.1762 25.818 93.8382 24.92C94.4672 24.064 95.0642 23.255 96.3362 23.504Z" fill="black"
							/>
							<path d="M107.16 42.976C106.738 42.19 106.299 41.369 105.873 40.572C106.926 38.66 107.978 38.166 109.469 38.85C110.057 39.12 110.299 39.577 110.153 40.205C109.954 41.068 109.678 41.916 108.983 42.514C108.492 42.935 107.914 43.205 107.16 42.976Z" fill="black"
							/>
							<path d="M45.7482 13.598C45.4982 14.83 43.6893 15.898 42.5393 15.523C42.3933 15.475 42.2343 15.396 42.1313 15.286C41.5783 14.695 41.5333 12.985 42.0393 12.364C42.7253 11.522 44.2422 11.273 45.0762 11.93C45.6042 12.346 45.8182 12.954 45.7482 13.598Z" fill="black"
							/>
							<path d="M62.6021 60.476C60.2951 60.503 60.295 60.503 60.123 59.02C60.377 58.64 60.6561 58.923 60.9351 58.978C61.4471 59.076 61.8301 58.914 62.1091 58.435C62.6521 57.508 62.67 57.518 63.929 57.089C64.077 57.409 64.3251 57.734 64.3701 58.084C64.4811 58.947 64.5461 59.822 64.5461 60.692C64.5461 61.367 64.2671 61.915 63.3231 62.044C63.0881 61.533 62.8401 60.995 62.6021 60.476Z"
							fill="black" />
							<path d="M84.02 54.013C84.163 54.756 83.719 55.267 83.211 55.602C82.498 56.072 81.695 56.422 80.899 56.745C80.362 56.963 79.821 56.411 79.895 55.8C80.032 54.663 80.752 53.941 81.704 53.484C82.557 53.073 83.383 53.232 84.02 54.013Z" fill="black" />
							</svg>
						</div>
					</div>
				</div>
			';

		}
		
	}

}

// Register our new widget
Plugin::instance()->widgets_manager->register_widget_type( new Widget_TommusRhodus_Iphone_Screenshot_Block() );