<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

class Widget_TommusRhodus_Decorations_Block extends Widget_Base {
	
	//Return Class Name
	public function get_name() {
		return 'tommusrhodus-decorations-block';
	}
	
	//Return Block Title (for blocks list)
	public function get_title() {
		return esc_html__( 'Section Decorations', 'tr-framework' );
	}
	
	//Return Block Icon (for blocks list)
	public function get_icon() {
		return 'eicon-slideshow';
	}
	
	public function get_categories() {
		return [ 'uptime-elements' ];
	}

	protected function _register_controls() {
		
		$this->start_controls_section(
			'section_my_custom', [
				'label' => esc_html__( 'Decorations Settings', 'tr-framework' ),
			]
		);		

		$this->end_controls_section();

		$this->start_controls_section(
			'slider_items_section', [
				'label' => __( 'Decorations', 'tr-framework' )
			]
		);

		$repeater = new Repeater();

		$repeater->add_control(
			'layout', [
				'label'   => __( 'Choose a Decoration', 'tr-framework' ),
				'type'    => Controls_Manager::SELECT,
				'default' => 'blob_bottom_left',
				'label_block' => true,
				'options' => [
					'blob_bottom_left'					=> esc_html__( 'Blob, Positon Bottom Left', 'tr-framework' ),
					'blob_bottom_left_alt'				=> esc_html__( 'Blob Alt, Positon Bottom Left', 'tr-framework' ),
					'blob_bottom_right'					=> esc_html__( 'Blob, Positon Bottom Right', 'tr-framework' ),
					'blob_right'						=> esc_html__( 'Blob, Positon Right', 'tr-framework' ),
					'blob_top_left'						=> esc_html__( 'Blob, Positon Top Left', 'tr-framework' ),
					'blob_outline_left'					=> esc_html__( 'Blob Outline, Positon Left', 'tr-framework' ),
					'blob_left'							=> esc_html__( 'Blob, Positon Left', 'tr-framework' ),					
					'blob_top_right'					=> esc_html__( 'Blob, Positon Top Right', 'tr-framework' ),
					'lines_bottom_right'				=> esc_html__( 'Lines, Positon Bottom Right', 'tr-framework' ),
					'lines_right'						=> esc_html__( 'Lines, Positon Right', 'tr-framework' ),
					'lines_bottom_right_small'			=> esc_html__( 'Lines Small, Positon Bottom Right', 'tr-framework' ),
				],
			]
		);

		$this->add_control(
			'list', [
				'label'   => __( 'Slide Content', 'tr-framework' ),
				'type'    => Controls_Manager::REPEATER,
				'fields'  => $repeater->get_controls(),
				'default' => [],
				'title_field' => __( 'Slide Content', 'tr-framework' ),
			]
		);		

		$this->end_controls_section();

	}

	protected function render() {
		
		$settings                = $this->get_settings_for_display();
		$user_selected_animation = (bool) $settings['_animation'];
	
		echo '
			<div class="decoration-wrapper decoration-wrapper-block d-none d-sm-block">';

				foreach( $settings['list'] as $item ){

					if( 'blob_bottom_left' == $item['layout'] ) {
						echo '
							<div class="decoration bottom middle-y scale-5">
					          <svg class="bg-primary" width="183" height="166" viewBox="0 0 183 166" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M2.34805 65.6701C4.02805 62.9901 5.56905 60.211 7.41605 57.652C10.82 52.939 14.734 48.636 18.627 44.322C21.811 40.794 24.9 37.181 28.08 33.65C30.619 30.831 32.879 27.721 36.068 25.554C39.035 23.539 42.066 21.62 45.039 19.616C46.439 18.674 47.812 17.682 49.123 16.624C51.525 14.687 54.035 12.972 56.996 11.982C57.787 11.717 58.5371 11.285 59.2561 10.847C63.3111 8.36802 67.328 5.82603 71.408 3.38703C73.033 2.41503 74.7361 1.53704 76.4881 0.824045C78.4981 0.00604486 80.615 -0.0229468 82.701 0.670053C84.805 1.36905 86.912 2.05405 88.994 2.81205C90.217 3.25705 91.426 3.55605 92.701 3.15705C94.228 2.67905 95.5971 3.14904 96.9921 3.72804C99.4631 4.75604 101.484 6.48703 103.691 7.92603C104.574 8.50203 105.353 9.24603 106.257 9.77903C107.429 10.469 108.624 11.197 109.905 11.604C112.95 12.57 115.751 13.945 118.466 15.634C124.386 19.315 130.482 22.6901 137.122 24.9461C141.015 26.2681 144.968 27.425 148.802 28.897C153.036 30.522 157.224 32.289 161.009 34.866C162.577 35.934 164.195 36.928 165.802 37.937C171.439 41.473 175.253 46.641 178.368 52.335C180.1 55.5 180.626 59.127 181.403 62.633C182.262 66.502 182.116 70.416 181.868 74.311C181.587 78.733 181.095 83.142 180.665 87.554C180.462 89.618 179.534 91.337 178.192 92.927C175.192 96.484 172.45 100.218 170.514 104.504C169.549 106.642 168.932 108.863 168.332 111.109C167.514 114.168 166.631 117.2 165.352 120.117C163.209 124.994 160.215 129.302 156.885 133.411C156.498 133.89 156.188 134.472 155.996 135.057C155.039 137.993 153.416 140.578 151.975 143.28C149.35 148.2 145.637 152.224 142.088 156.405C141.611 156.967 141.123 157.548 140.539 157.985C136.902 160.704 133.254 163.385 128.863 164.86C126.806 165.552 124.752 165.891 122.634 165.534C120.347 165.149 117.966 164.899 115.843 164.048C113.527 163.117 111.435 161.605 109.294 160.267C107.773 159.316 106.386 158.149 104.851 157.226C101.417 155.162 97.923 153.198 94.464 151.177C93.37 150.539 92.3001 149.863 91.2301 149.187C90.7851 148.904 90.4021 148.509 89.9331 148.281C85.2771 146.008 81.023 143.033 76.49 140.568C71.861 138.051 67.103 135.705 61.888 134.538C61.374 134.423 60.837 134.338 60.361 134.126C54.332 131.453 47.812 130.439 41.547 128.568C37.799 127.449 34.072 126.33 30.547 124.58C26.953 122.795 23.2871 121.148 19.6391 119.475C16.4031 117.991 13.774 115.777 11.504 113.057C9.25404 110.358 7.32204 107.492 6.06804 104.188C4.82404 100.913 3.92305 97.569 3.70305 94.057C3.63705 93.004 3.53704 91.946 3.33804 90.912C2.34204 85.728 1.53504 80.525 0.926042 75.276C0.531042 71.872 1.00605 68.7731 2.34805 65.6701ZM57.891 130.289C57.84 130.228 57.791 130.168 57.741 130.107C57.682 130.158 57.5811 130.203 57.5751 130.257C57.5711 130.312 57.657 130.416 57.714 130.422C57.766 130.429 57.83 130.338 57.891 130.289ZM111.725 160.38C111.678 160.322 111.635 160.227 111.582 160.22C111.531 160.213 111.469 160.302 111.412 160.349C111.459 160.406 111.502 160.502 111.555 160.507C111.608 160.512 111.668 160.426 111.725 160.38ZM141.531 85.2951L141.57 85.501L141.736 85.369L141.531 85.2951Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}	

					if( 'blob_bottom_left_alt' == $item['layout'] ) {
						echo '
							<div class="decoration bottom left scale-3">
					          <svg class="bg-primary-2" width="135" height="206" viewBox="0 0 135 206" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M60.5599 1.23097C64.9269 1.44397 69.7339 1.598 74.5289 1.946C77.0019 2.126 79.4569 2.61399 81.9099 3.02299C85.7209 3.65899 89.4979 4.637 93.3319 4.95C100.982 5.572 108.102 8.05497 115.238 10.567C118.152 11.593 121.043 12.692 123.97 13.684C125.589 14.233 126.911 15.155 127.816 16.563C129.066 18.508 130.453 20.428 131.296 22.55C132.007 24.338 132.097 26.393 132.343 28.344C132.997 33.537 133.73 38.728 134.14 43.942C134.312 46.13 133.915 48.408 133.49 50.588C132.371 56.318 131.154 62.032 129.863 67.727C128.574 73.424 127.207 79.106 125.767 84.768C124.263 90.678 122.726 96.583 121.025 102.439C119.877 106.389 118.421 110.25 117.095 114.148C116.847 114.88 116.497 115.582 116.292 116.324C114.382 123.22 111.356 129.695 108.813 136.353C107.067 140.927 105.219 145.468 103.637 150.099C102.428 153.636 100.489 156.771 98.8339 160.068C96.8609 164.002 94.6599 167.775 91.9059 171.216C91.6379 171.55 91.3419 171.888 91.1739 172.275C89.5079 176.127 86.7209 179.199 84.0979 182.373C81.5259 185.486 78.9519 188.615 76.1549 191.523C68.6159 199.361 59.4519 204.023 48.5589 205.109C48.0469 205.16 47.5199 205.214 47.0159 205.148C43.4569 204.679 39.9029 204.185 36.3479 203.689C31.0319 202.945 25.9359 201.337 21.0389 199.251C17.6619 197.813 14.5429 195.771 11.3199 193.976C10.6459 193.603 10.0559 193.078 9.37891 192.714C4.71891 190.216 2.12291 186.216 1.18991 181.14C0.240908 175.974 0.117912 170.738 0.183912 165.486C0.249912 160.334 0.0549003 155.179 0.0379003 150.025C0.0239003 145.132 0.0968999 140.238 0.1219 135.345C0.1549 129.251 0.0989109 123.156 0.226911 117.062C0.361911 110.714 -0.183096 104.348 0.781904 98.018C1.11791 95.811 1.1709 93.561 1.4929 91.351C2.3699 85.319 3.32891 79.298 4.24091 73.272C4.43391 71.998 4.5069 70.703 4.7429 69.437C5.7469 64.036 6.73491 58.631 7.83691 53.249C8.78591 48.622 9.78391 44.001 10.9439 39.424C11.7859 36.098 12.8639 32.828 13.9459 29.57C15.5419 24.763 16.7549 19.807 19.2289 15.329C21.2019 11.76 23.6059 8.51399 26.9769 6.14699C29.7679 4.18699 33.0549 3.32797 36.3189 2.57997C44.7239 0.651972 51.2199 0.329973 60.5599 1.23097ZM105.419 53.443C105.22 53.077 105.023 52.712 104.823 52.346C104.702 52.446 104.581 52.545 104.458 52.645C104.778 52.911 105.099 53.177 105.417 53.444C105.478 53.936 105.427 54.477 105.618 54.911C106.126 56.062 106.862 55.945 107.761 55.212C107.261 54.83 106.884 54.539 106.503 54.252C106.144 53.979 105.78 53.711 105.419 53.443ZM76.2879 124.701C75.1119 122.146 74.0989 121.558 72.7819 122.418C72.5549 122.564 72.4169 122.965 72.3909 123.26C72.3769 123.442 72.6209 123.768 72.8109 123.822C73.8409 124.121 74.8899 124.357 76.2879 124.701ZM67.4479 116.584C65.6959 117.957 65.6919 118.332 67.5669 119.297C67.8579 118.342 68.3679 117.496 67.4479 116.584ZM57.7059 114.078C59.6399 113.396 59.6399 113.396 58.9949 111.521C58.5869 112.334 58.2709 112.961 57.7059 114.078ZM94.2389 47.635C94.3579 47.316 94.5339 47.081 94.4829 46.916C94.4319 46.748 94.1569 46.647 93.9809 46.518C93.8739 46.707 93.6609 46.916 93.6899 47.08C93.7239 47.257 93.9829 47.392 94.2389 47.635ZM43.9439 25.55C43.8599 25.65 43.7759 25.748 43.6919 25.847C43.7799 25.982 43.8439 26.2 43.9629 26.234C44.2269 26.309 44.5179 26.295 44.7969 26.316C44.5129 26.061 44.2279 25.806 43.9439 25.55ZM75.6459 39.062C75.7259 38.946 75.8879 38.808 75.8649 38.718C75.8339 38.592 75.6619 38.502 75.5509 38.397C75.4729 38.513 75.3109 38.65 75.3319 38.742C75.3619 38.866 75.5319 38.957 75.6459 39.062Z"
					            fill="black" />
					          </svg>

					        </div>
						';
					}	

					if( 'lines_bottom_right' == $item['layout'] ) {
						echo '
						 	<div class="decoration bottom right scale-5">
						          <svg class="bg-primary-2" width="81" height="99" viewBox="0 0 81 99" fill="none" xmlns="http://www.w3.org/2000/svg">
						            <path d="M16.512 39.034C15.694 39.503 14.793 39.858 14.094 40.452C12.276 41.993 10.356 43.475 8.82596 45.278C6.21296 48.36 6.58998 51.078 9.57798 54.153C10.094 54.685 10.955 54.907 11.685 55.194C12.044 55.337 12.476 55.28 12.867 55.352C15.017 55.748 15.705 56.688 15.555 59.035C11.016 60.872 7.36398 59.407 4.22098 55.993C2.15998 53.756 0.741962 51.231 0.661962 48.11C0.632962 46.994 0.790977 45.962 1.37098 44.914C3.54698 40.972 6.52296 37.87 10.412 35.592C11.707 34.833 13.039 34.918 14.351 35.188C15.306 35.385 15.997 36.129 16.206 37.163C16.34 37.815 16.422 38.479 16.512 39.034Z"
						            fill="black" />
						            <path d="M15.697 74.223C12.558 75.928 10.693 78.761 9.33598 81.818C7.54498 85.852 9.06098 90.272 14.078 90.917C14.887 91.021 15.717 91.46 16.394 91.946C17.511 92.749 17.462 92.817 17.347 94.582C14.38 95.921 11.482 95.849 8.72196 94.045C7.45596 93.218 6.21997 92.335 5.04597 91.382C1.89797 88.829 0.949985 81.801 2.99699 78.751C4.01799 77.23 4.76297 75.515 5.83497 74.034C7.72997 71.419 10.22 70.101 13.702 71.617C14.943 72.155 15.049 73.297 15.697 74.223Z"
						            fill="black" />
						            <path d="M78.5449 75.006C76.3729 74.601 75.3419 76.242 74.1429 77.555C72.8619 78.959 72.1569 80.623 72.2269 82.559C72.3869 87.028 74.3889 90.526 78.0839 92.942C79.2399 93.698 79.3539 94.837 80.1699 95.958C79.5739 95.958 79.1369 95.825 78.8579 95.978C76.0829 97.503 74.0079 96.236 72.0439 94.367C70.2509 92.66 68.4229 91.002 67.2859 88.732C66.0829 86.332 65.3249 83.839 65.5929 81.135C66.0289 76.765 68.6159 73.762 71.8999 71.146C73.3389 70 74.8039 70.028 76.3999 70.414C77.5559 70.692 78.1069 71.489 78.2359 72.637C78.3159 73.379 78.4279 74.121 78.5449 75.006Z"
						            fill="black" />
						            <path d="M50.3418 83.795C47.8708 83.591 45.2398 83.449 42.7048 84.279C41.0388 88.606 42.7048 93.074 46.9178 95.201C48.1448 95.82 49.0408 96.512 49.3608 98.029C48.3408 98.302 47.3058 98.584 46.2688 98.859C45.2998 99.118 44.3958 98.97 43.4818 98.543C37.4038 95.701 33.8938 88.395 35.5428 81.908C35.7188 81.217 36.0308 80.558 36.2988 79.892C36.6208 79.089 37.2028 78.615 38.0698 78.451C41.0778 77.885 44.0858 77.664 47.1268 78.22C48.5698 78.485 49.5718 79.389 50.4468 80.41C51.2928 81.396 51.4728 82.543 50.3418 83.795Z"
						            fill="black" />
						            <path d="M78.367 7.67896C76.728 7.85196 75.308 8.00099 73.888 8.15199C72.019 8.34999 70.921 9.27497 70.372 11.176C69.458 14.353 69.804 17.353 71.183 20.254C71.49 20.9 72.251 21.386 72.896 21.802C74.689 22.958 76.613 23.942 77.738 26.096C75.463 27.089 73.3 27.21 71.023 26.032C65.492 23.173 63.347 18.18 63.968 12.031C64.157 10.158 64.874 8.31997 65.493 6.51597C66.048 4.90197 67.288 3.77699 68.946 3.48899C70.899 3.14999 72.905 3.07497 74.891 2.98597C75.942 2.93897 76.723 3.57297 77.149 4.50397C77.604 5.49397 77.938 6.53796 78.367 7.67896Z"
						            fill="black" />
						            <path d="M45.898 11.393C44.492 10.616 44.472 10.618 43.916 11.645C42.529 14.197 42.822 16.754 44.828 18.882C45.478 19.571 46.219 20.213 47.016 20.72C48.481 21.652 49.954 22.528 50.192 24.534C49.585 24.68 48.784 24.712 48.153 25.056C46.801 25.793 45.633 25.606 44.323 24.907C41.643 23.479 39.428 21.542 37.858 18.984C36.092 16.107 35.942 12.919 36.899 9.745C37.524 7.676 39.237 6.54302 41.2 5.90702C42.944 5.34102 44.739 4.91199 46.532 4.51999C48.641 4.05999 50.067 4.95502 50.714 7.04902C50.923 7.72402 51.066 8.42101 51.304 9.36701C50.204 9.76101 49.103 10.138 48.017 10.549C47.292 10.823 46.589 11.147 45.876 11.449L45.898 11.393Z"
						            fill="black" />
						            <path d="M19.6431 5.52198C18.6041 5.46998 17.909 5.46799 17.219 5.39399C15.08 5.16299 13.449 6.00099 12.369 7.80299C11.473 9.29899 10.721 10.88 9.90007 12.434C10.222 12.967 10.517 13.344 10.697 13.77C11.25 15.085 12.349 15.408 13.611 15.439C14.166 15.452 14.722 15.377 15.279 15.369C17.363 15.334 18.3261 16.139 18.6771 18.216C18.7301 18.522 18.7101 18.839 18.7241 19.13C13.6791 21.07 8.77708 19.623 5.57808 16.217C4.24008 14.791 3.58807 12.961 3.85307 10.912C4.19307 8.30596 5.33908 6.02299 6.79408 3.91099C7.83508 2.39799 9.59309 1.80197 11.2391 1.23597C12.4271 0.826969 13.739 0.693967 15.007 0.614967C17.064 0.485967 18.028 1.20798 18.757 3.16498C19.018 3.86498 19.2811 4.56298 19.6431 5.52198Z"
						            fill="black" />
						            <path d="M44.8359 43.951C44.5839 44.067 44.4469 44.168 44.2969 44.193C40.0179 44.92 39.9039 48.017 41.3909 51.291C42.1799 53.03 43.8169 54.395 45.1229 55.884C45.5369 56.354 46.0839 56.738 46.6349 57.048C48.2289 57.946 49.4869 59.055 49.4079 61.244C48.3509 61.41 47.1399 61.677 45.9199 61.754C45.4219 61.787 44.8589 61.477 44.3909 61.209C40.5649 59.016 37.5139 55.98 35.4109 52.143C33.4579 48.585 33.1489 44.837 35.5809 41.295C36.9579 39.289 39.1669 38.775 41.4309 38.563C42.2079 38.49 42.7529 38.969 43.1599 39.637C43.9489 40.933 44.6229 42.266 44.8359 43.951Z"
						            fill="black" />
						            <path d="M76.0799 56.7771C73.8919 57.3361 71.6839 57.078 69.5139 56.634C67.7349 56.269 66.5409 54.89 65.9769 53.335C64.9499 50.503 63.8829 47.5892 63.5389 44.6272C63.0189 40.1442 65.2439 37.073 70.0369 36.672C70.5139 36.632 70.9939 36.615 71.4709 36.621C74.4729 36.654 75.3849 37.559 75.6639 40.847C74.8769 40.847 74.0979 40.84 73.3179 40.848C70.7069 40.875 69.2299 42.4121 69.6129 44.9371C69.9199 46.9721 70.4179 48.985 70.9449 50.978C71.2749 52.235 72.1329 52.87 73.5349 53.043C76.1739 53.373 76.5329 54.0101 76.0799 56.7771Z"
						            fill="black" />
						          </svg>
					        </div>
						';
					}

					if( 'blob_right' == $item['layout'] ) {
						echo '
						 	<div class="decoration right middle-y scale-5" data-jarallax-element="200">
					          <svg class="bg-primary-2" width="181" height="248" viewBox="0 0 181 248" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M173.496 137.406C174.74 140.125 174.201 142.961 172.992 145.955C171.785 148.945 171.244 152.203 170.371 155.332C169.545 158.285 169.023 161.391 167.74 164.135C164.455 171.167 160.851 178.053 157.302 184.959C156.15 187.203 154.769 189.328 153.507 191.517C150.778 196.252 146.98 200.155 143.411 204.207C139.247 208.934 134.907 213.528 130.36 217.884C126.981 221.119 123.356 224.19 119.477 226.79C110.78 232.623 101.875 238.142 91.7499 241.311C88.3119 242.386 84.9839 243.811 81.5509 244.904C73.1449 247.579 64.4319 248.129 55.8069 247.077C43.0409 245.519 34.2129 238.431 30.1099 226.075C28.8639 222.324 28.1059 218.372 27.5139 214.454C26.8169 209.821 26.5859 205.12 26.0709 200.456C25.3349 193.802 24.3459 187.22 21.4659 181.048C18.4739 174.631 16.5169 167.857 15.4639 160.864C14.0029 151.18 11.2059 141.854 8.4269 132.5C6.2689 125.236 4.1689 117.936 3.2239 110.374C3.0229 108.764 2.7159 107.161 2.3649 105.576C1.5039 101.679 1.03089 97.749 1.08989 93.75C1.11089 92.31 1.1309 90.823 0.8169 89.433C-0.1261 85.264 0.427893 81.211 1.17589 77.083C2.60189 69.223 4.9509 61.659 7.8319 54.234C11.6759 44.329 17.4339 35.662 24.7729 28.024C27.4019 25.289 30.1459 22.662 32.7379 19.892C41.5149 10.511 52.7829 5.93202 64.9919 3.34302C76.9139 0.815015 89.0599 0.543025 101.144 1.31003C118.3 2.39903 134.746 6.51404 149.367 15.95C158.662 21.948 165.805 29.942 169.615 40.639C172.851 49.726 174.459 59.13 175.758 68.625C176.248 72.201 176.719 75.792 177.459 79.32C179.471 88.912 180.406 98.573 180.119 108.383C179.885 116.393 178.273 124.157 176.322 131.861C175.854 133.709 174.568 135.353 173.496 137.406ZM114.193 74.056C116.129 74.66 116.129 74.66 116.709 73.132C115.756 73.482 114.975 73.769 114.193 74.056Z"
					            fill="black" />
					          </svg>
        					</div>
						';
					}

					if( 'blob_top_left' == $item['layout'] ) {
						echo '
						 	<div class="decoration top left scale-5" data-jarallax-element="50">
					          <svg class="bg-primary" width="43" height="122" viewBox="0 0 43 122" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M27.7833 0.279065C31.5153 -0.395935 34.1643 0.647081 35.8243 3.52708C37.3013 3.75308 38.6543 3.75507 39.8533 4.18507C42.1543 5.01007 42.9763 6.54608 42.4253 8.85508C41.9003 11.0481 41.2363 13.2141 40.5173 15.3541C39.3333 18.8831 38.0523 22.3801 36.8223 25.8941C36.5623 26.6401 36.3473 27.4031 36.1253 28.1161C37.0183 29.7191 37.8983 31.1721 38.6433 32.6931C38.9753 33.3751 39.2763 34.2291 39.1643 34.9391C38.7993 37.2861 38.4123 39.6531 37.7263 41.9191C34.3003 53.2441 30.6563 64.5041 27.3223 75.8571C24.0643 86.9611 21.6093 98.2541 20.5933 109.813C20.3373 112.721 20.3023 115.648 20.1133 118.563C20.0643 119.327 19.8203 120.077 19.6813 120.759C15.5443 121.634 15.1673 121.063 12.5563 118.159C10.5703 115.952 10.0543 113.611 9.89033 110.991C9.78533 109.283 9.15631 107.965 7.99531 106.752C5.98531 104.652 4.13033 102.404 2.07933 100.35C1.36233 99.6311 0.903309 98.9591 0.886309 97.9751C0.820309 94.3911 0.722321 90.8071 0.698321 87.2231C0.682321 84.7301 1.61831 82.2831 0.753314 79.7161C0.466314 78.8631 1.1893 77.7051 1.3173 76.6701C1.5593 74.6961 1.55332 72.6821 1.92232 70.7361C2.96332 65.2691 4.04931 59.8211 5.40431 54.4081C7.37531 46.5491 9.58832 38.7701 11.8923 31.0121C12.5353 28.8511 13.2773 26.7081 14.1303 24.6221C16.2923 19.3441 18.5343 14.0991 20.7713 8.85109C21.0273 8.24809 21.3243 7.49607 21.8303 7.19307C24.5723 5.55607 25.8093 2.64406 27.7833 0.279065Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}	

					if( 'blob_outline_left' == $item['layout'] ) {
						echo '
						 	<div class="decoration top middle-y scale-2" data-jarallax-element="-50 -50">
					          <svg class="bg-primary-2" width="257" height="200" viewBox="0 0 257 200" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M52.4279 199.385C43.0839 199.209 36.3889 195.125 32.1679 186.768C27.0589 176.651 23.0699 166.059 18.5959 155.67C14.4909 146.139 11.7989 136.287 9.8339 126.129C8.3399 118.4 6.2499 110.777 4.2029 103.166C1.6089 93.512 1.1799 83.586 0.327904 73.727C0.0159039 70.11 0.526895 66.342 1.17789 62.735C3.21689 51.438 5.9829 40.346 11.6529 30.198C17.3889 19.928 24.6629 11.067 34.9749 5.09298C41.4319 1.35298 48.4239 -0.117996 55.8949 0.868004C57.9049 1.134 59.9499 1.2 61.9789 1.225C71.0429 1.332 79.9579 2.518 88.7739 4.635C99.0339 7.1 109.327 9.44598 119.891 10.244C124.323 10.578 128.77 10.765 133.196 11.16C142.811 12.017 152.415 13.006 162.03 13.869C169.618 14.551 177.214 15.588 184.811 15.637C194.612 15.698 203.692 17.942 212.225 22.553C219.284 26.367 225.918 30.826 232.161 35.899C237.325 40.096 239.942 45.866 242.524 51.674C245.827 59.108 248.79 66.699 252.278 74.043C253.758 77.166 254.821 80.272 255.723 83.602C258.006 92.018 256.088 99.834 252.858 107.36C247.544 119.743 238.922 129.653 228.809 138.475C223.024 143.522 217.065 148.209 210.334 151.858C201.387 156.712 192.336 161.282 182.279 163.602C175.226 165.229 168.332 167.526 161.322 169.358C150.377 172.221 139.363 174.829 128.441 177.782C124.039 178.973 119.779 180.723 115.502 182.346C108.85 184.867 102.33 187.789 95.5759 189.989C90.2869 191.712 84.7239 192.6 79.2829 193.852C73.0899 195.278 66.9079 196.752 60.6949 198.086C57.9729 198.67 55.1859 198.961 52.4279 199.385ZM2.4139 69.891C2.8909 77.291 2.8549 82.676 3.6699 87.928C4.8339 95.455 6.5329 102.903 8.1679 110.348C9.3969 115.936 11.0959 121.424 12.2069 127.03C13.8459 135.284 15.6869 143.446 19.1909 151.153C20.4529 153.928 21.7179 156.725 22.6929 159.61C25.8409 168.926 30.5069 177.551 34.7049 186.391C37.0959 191.42 40.8749 194.725 46.3479 195.953C47.9519 196.312 49.6189 196.803 51.2149 196.682C54.9999 196.397 58.7989 195.971 62.5239 195.246C66.6369 194.447 70.6199 192.838 74.7529 192.307C87.1079 190.719 98.8939 187.225 110.206 182.157C122.585 176.61 135.595 173.192 148.706 169.997C166.852 165.575 185.198 161.819 202.196 153.577C208.983 150.286 215.481 146.638 221.26 141.774C223.399 139.973 225.467 138.086 227.641 136.329C237.504 128.349 245.12 118.612 250.375 107.075C252.391 102.651 253.904 98.11 252.98 93.059C252.503 90.45 252.259 87.741 252.384 85.1C252.501 82.6 251.993 80.356 251.236 78.032C247.797 67.473 242.777 57.591 238.306 47.475C236.376 43.108 233.327 39.489 229.482 36.631C226.017 34.059 222.412 31.676 218.953 29.096C211.025 23.188 202.168 19.569 192.383 18.366C187.85 17.807 183.258 17.751 178.699 17.372C170.855 16.718 163.011 16.044 155.178 15.274C150.75 14.838 146.356 14.057 141.926 13.686C136.612 13.239 131.27 13.122 125.947 12.75C121.259 12.422 116.533 12.232 111.91 11.461C104.894 10.293 97.9309 8.775 90.9859 7.225C81.2789 5.059 71.5269 3.41799 61.5349 3.57699C59.8899 3.60399 58.2319 3.431 56.5989 3.208C47.8569 2.015 39.8019 4.02999 32.7179 9.07699C24.4229 14.985 18.0729 22.706 13.2099 31.694C9.53991 38.479 7.1459 45.712 5.4439 53.155C4.0329 59.334 3.1679 65.637 2.4139 69.891Z"
					            fill="black" />
					          </svg>
				          	</div>
						';
					}	

					if( 'lines_right' == $item['layout'] ) {
						echo '
							<div class="decoration middle-y right scale-2" data-jarallax-element="50 0">
					          <svg class="bg-primary" width="110" height="116" viewBox="0 0 110 116" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M56.0201 7.05393C59.1721 4.51793 59.7681 4.46094 62.2881 6.41394C62.0951 6.69994 61.9211 7.01594 61.6921 7.28394C61.1841 7.88094 61.1741 7.87095 61.8561 8.97595C61.3271 9.84795 60.7561 10.786 60.1081 11.855C60.6431 12.46 61.1801 13.029 61.6701 13.635C62.1681 14.251 62.7231 14.8549 63.0631 15.5549C63.3851 16.2189 63.4631 17.002 63.6741 17.834C61.8561 18.334 60.2351 18.0659 58.8281 16.7719C58.2441 16.2349 57.6871 15.6679 57.1821 15.1749C56.2431 15.0949 55.7871 15.743 55.2171 16.135C53.3071 17.447 51.3931 18.7399 49.1231 19.3709C48.8961 19.4339 48.6581 19.4569 48.4691 19.4919C48.2741 19.4259 48.1001 19.4089 47.9791 19.3199C46.3381 18.1189 46.1781 17.4189 47.3031 15.8059C47.6551 15.3039 48.1841 14.9089 48.6781 14.5269C49.2421 14.0899 49.8931 13.7629 50.4511 13.3179C53.4801 10.8969 53.0801 11.0889 51.2521 8.46894C49.9811 6.64594 48.9201 4.67293 47.8111 2.73993C47.3131 1.87393 47.3461 0.917928 47.8421 0.536928C48.5101 0.0219278 49.2811 -0.108072 50.1001 0.161928C51.0711 0.481928 51.6641 1.24693 52.2331 2.01593C53.1781 3.29693 54.0751 4.61694 55.0121 5.90494C55.2831 6.28094 55.6231 6.60693 56.0201 7.05393Z"
					            fill="black" />
					            <path d="M45.2522 52.563C45.6802 53.121 45.8982 53.446 46.1582 53.735C46.5842 54.211 47.0332 54.6671 47.4802 55.1261C49.0032 56.6921 49.6262 58.568 49.4842 60.869C48.4452 60.965 47.5882 60.5641 46.7712 60.1421C46.0742 59.7831 45.2692 59.4151 44.8262 58.8201C43.6172 57.1911 41.8062 56.2541 40.6542 54.6871C39.7752 54.8601 39.0842 55.004 38.3882 55.132C37.0792 55.372 36.1932 54.8641 35.8572 53.6091C35.7382 53.1581 35.6072 52.572 35.7912 52.201C36.5312 50.712 35.6662 49.5981 35.0312 48.4401C34.6852 47.8071 34.2602 47.2361 34.2672 46.4651C34.2752 45.6621 34.8082 45.0261 35.6092 45.1341C36.2972 45.2281 37.0002 45.4641 37.6092 45.7971C38.1562 46.0961 38.6462 46.562 39.0502 47.046C40.0402 48.224 41.1552 48.3071 42.4562 47.6401C43.2372 47.2391 44.0502 46.9001 44.8542 46.5481C45.5122 46.2611 46.1842 46.0071 46.8402 45.7201C49.0592 44.7491 50.9102 46.8641 51.0632 48.8941C51.1082 49.5121 50.8132 50.0041 50.2742 50.2671C49.3422 50.7221 48.3762 51.106 47.4302 51.533C46.7832 51.825 46.1452 52.14 45.2522 52.563Z"
					            fill="black" />
					            <path d="M70.824 40.181C70.357 40.472 69.8729 40.739 69.4259 41.059C68.7969 41.512 68.141 41.636 67.364 41.35C66.548 40.289 66.532 39.2 67.315 38.089C67.999 37.12 68.6859 36.153 69.4609 35.058C68.9789 34.524 68.5389 33.972 68.0329 33.488C66.9839 32.484 66.2029 31.295 65.4179 30.087C64.7319 29.033 64.717 28.035 65.203 26.77C65.746 26.841 66.348 26.767 66.769 27.007C67.589 27.474 68.3569 28.067 69.0599 28.701C70.2439 29.764 71.359 30.901 72.527 32.03C73.672 31.734 74.2299 30.79 75.0039 30.147C75.9019 29.399 76.8419 28.883 78.0629 29.19C78.6059 29.326 79.135 29.419 79.514 29.923C79.793 30.297 80.1859 30.585 80.6119 30.991C80.5589 33.131 78.7249 34.322 77.6329 36.135C77.8769 36.432 78.123 36.818 78.449 37.114C79.707 38.251 80.2669 39.66 80.2009 41.443C78.6309 42.078 77.3239 41.327 76.0429 40.561C75.6409 40.32 75.318 39.938 74.984 39.596C74.466 39.065 73.8379 39.13 73.1969 39.21L73.2399 39.261C72.8629 39.052 72.4879 38.923 72.1189 39.277C72.0019 39.344 71.8919 39.422 71.7909 39.511C71.4469 39.75 71.103 39.99 70.76 40.228L70.824 40.181Z"
					            fill="black" />
					            <path d="M96.1969 45.298C95.2609 44.256 94.5079 43.44 93.7809 42.602C93.1009 41.821 92.3918 41.057 91.8038 40.21C91.1558 39.277 91.7079 38.274 92.8249 38.171C93.6489 38.095 94.4229 38.198 95.0869 38.719C95.8369 39.307 96.5689 39.916 97.2979 40.528C98.0269 41.139 98.7389 41.766 99.5419 42.457C100.458 42.04 101.009 41.271 101.649 40.588C102.602 39.573 104.172 39.237 105.364 39.766C106.288 40.176 106.975 40.789 106.88 41.942C106.847 42.334 106.837 42.738 106.896 43.124C107.029 43.992 106.81 44.633 106.05 45.176C105.421 45.624 104.941 46.275 104.413 46.816C104.772 47.655 105.151 48.343 105.358 49.079C105.542 49.736 105.532 50.447 105.631 51.329C103.625 51.114 101.963 50.533 100.447 49.324C99.7199 49.663 99.0109 49.994 98.3009 50.325C96.8339 51.011 95.2909 51.363 93.6699 51.312C92.8299 51.286 92.3768 50.75 92.3728 49.925C92.3648 48.594 93.1519 47.706 94.0639 46.91C94.6599 46.395 95.3219 45.956 96.1969 45.298Z"
					            fill="black" />
					            <path d="M101.844 91.355C102.533 90.708 103.045 90.219 103.565 89.738C104.352 89.009 105.28 88.59 106.346 88.473C107.282 88.371 108.116 88.97 108.166 89.915C108.268 91.837 108.137 93.727 106.768 95.423C108.45 96.804 109.608 98.433 109.563 100.773C108.346 101.144 107.262 100.505 106.223 100.104C105.217 99.716 104.348 98.97 103.33 98.326C101.726 98.993 100.053 99.693 98.373 100.385C98.08 100.506 97.783 100.629 97.475 100.697C96.645 100.881 95.815 100.256 95.86 99.408C95.889 98.869 96.03 98.293 96.278 97.814C96.825 96.761 97.471 95.758 98.178 94.563C98.037 94.205 97.905 93.663 97.625 93.21C97.336 92.741 96.9 92.363 96.541 91.937C95.252 90.409 94.629 88.672 94.853 86.662C96.527 86.557 97.419 86.893 98.632 88.123C99.193 88.691 99.696 89.314 100.253 89.885C100.695 90.336 101.18 90.745 101.844 91.355Z"
					            fill="black" />
					            <path d="M23.8872 15.5589C22.6252 16.2679 21.4532 16.9369 20.2702 17.5889C19.5822 17.9669 18.9482 18.371 18.0512 18.294C17.4892 18.246 16.8932 18.718 16.2972 18.911C15.7872 19.078 15.3522 18.905 15.0652 18.445C14.5652 17.646 14.4672 16.811 14.8952 15.945C15.4382 14.842 16.2172 13.9829 17.3132 13.3779C18.2802 12.8449 19.3152 12.3549 19.9202 11.1969C19.3592 9.76695 17.7032 9.25894 16.9362 8.01094C16.8932 7.24394 17.2312 6.65994 17.8252 6.39894C18.7062 6.00994 19.6772 5.88596 20.6122 6.28096C21.1262 6.49696 21.6142 6.77695 22.0922 7.06395C22.7742 7.47495 23.4342 7.91995 24.2092 8.41795C24.7172 8.15295 25.2932 7.89896 25.8202 7.56496C26.7812 6.95896 27.7732 7.01394 28.8182 7.26094C29.9662 7.53194 30.3612 8.55595 30.9042 9.37795C31.0842 9.64995 30.8492 10.318 30.6272 10.7C30.3972 11.094 29.9572 11.3709 29.5922 11.6789C29.1082 12.0869 28.6082 12.4749 28.1312 12.8569C28.4202 14.3099 28.7292 15.684 28.9552 17.071C29.0742 17.812 28.4632 18.199 27.7152 17.906C27.0492 17.645 26.3522 17.423 25.7442 17.057C25.1452 16.698 24.6412 16.1789 23.8872 15.5589Z"
					            fill="black" />
					            <path d="M69.8009 69.525C69.1799 68.537 68.5409 67.532 67.9119 66.521C67.3529 65.621 67.0229 64.642 67.0159 63.58C67.0039 62.432 67.9179 61.762 68.9379 62.264C69.6289 62.604 70.2659 63.135 70.8009 63.7C71.5629 64.504 72.2109 65.417 72.9669 66.358C73.7209 66.049 74.4259 65.711 75.1619 65.469C76.9219 64.891 78.1719 65.803 78.5489 67.666C78.8359 69.082 78.6329 70.163 77.2109 70.859C77.6349 73.103 79.7929 74.8 79.2129 77.494C77.3889 76.984 75.6059 76.826 74.3259 75.264C73.4779 74.231 72.7649 74.256 71.6149 75.024C70.6209 75.686 69.6499 76.385 68.6399 77.02C67.9329 77.464 67.2119 77.227 66.8369 76.483C66.2609 75.338 66.1319 74.174 66.9419 73.094C67.7969 71.954 68.7209 70.867 69.8009 69.525Z"
					            fill="black" />
					            <path d="M11.2291 50.851C12.3481 53.413 12.3931 53.754 11.8481 55.872C11.4161 55.737 10.9671 55.659 10.5781 55.459C9.80111 55.06 8.99812 54.671 8.31212 54.141C6.20712 52.516 6.17311 52.571 3.67711 53.987C3.16711 53.747 2.60311 53.481 2.13611 53.261C1.51111 51.93 1.95211 50.83 2.50511 49.796C1.85111 48.519 1.2841 47.296 0.616104 46.134C-0.160896 44.784 -0.115892 43.569 1.02611 42.371C3.56311 42.53 4.2331 45.257 6.2921 46.302C7.2761 46.048 7.9011 45.2 8.5631 44.438C9.0941 43.825 9.64111 43.278 10.4181 42.984C12.0331 42.374 13.3071 42.783 14.3031 44.259C15.3191 45.762 15.3601 46.257 14.2371 47.622C13.3361 48.723 12.2991 49.713 11.2291 50.851Z"
					            fill="black" />
					            <path d="M103.832 64.201C106.49 63.505 107.318 63.6351 108.391 64.8361C109.336 65.8931 109.405 66.6721 108.692 68.6721C109.68 70.3131 110.381 72.0931 109.698 74.3111C109.05 73.9241 108.542 73.5901 108.005 73.3091C107.368 72.9771 106.683 72.735 106.067 72.373C105.526 72.054 105.049 71.6231 104.512 71.2161C103.106 71.6291 101.725 72.0101 100.362 72.4441C99.5981 72.6871 98.8421 73.1131 98.1711 72.3221C97.5541 71.5961 97.4911 70.3191 98.0711 69.4281C98.4561 68.8361 98.9441 68.3051 99.4261 67.7831C99.6801 67.5081 100.02 67.3081 100.401 67.0121C100.012 66.4651 99.6881 66.0281 99.3831 65.5781C98.6251 64.4541 97.8771 63.3241 97.1211 62.1971C96.2131 60.8421 96.2541 59.3161 96.4511 57.8141C96.5131 57.3341 97.0121 56.9111 97.2651 56.5281C98.2981 56.5371 98.6011 57.2771 99.0091 57.8311C100.142 59.3731 101.212 60.9631 102.347 62.5041C102.811 63.1331 103.377 63.686 103.832 64.201Z"
					            fill="black" />
					            <path d="M107.551 8.04991C106.336 9.03991 105.123 10.0309 103.949 10.9879C104.795 13.7779 104.896 14.5269 104.662 16.3629C102.621 15.9779 101.082 14.7979 99.6482 13.3439C97.8102 13.9219 95.9982 14.4909 94.1682 15.0659C93.5982 14.7179 93.0662 14.3949 92.5762 14.0969C92.1762 12.8759 93.1172 12.2839 93.6832 11.5759C94.2242 10.9019 94.9212 10.3529 95.5582 9.74193C95.4432 8.91993 94.7202 8.62893 94.1812 8.19493C93.6282 7.74893 93.0312 7.35792 92.4842 6.96492C92.9982 5.24492 93.9632 4.56193 95.4272 4.95393C96.4192 5.21993 97.3762 5.64192 98.3232 6.05492C98.8992 6.30792 99.4272 6.67694 100.096 7.06194C100.524 6.76194 100.965 6.45292 101.407 6.14192C102.319 5.49992 103.19 4.78992 104.151 4.23192C105.473 3.46392 107.128 3.76191 108.051 4.89891C108.604 5.57991 108.459 6.38891 108.197 7.16591C108.31 6.78191 108.156 6.50592 107.783 6.70192C107.201 7.00592 107.16 7.51791 107.551 8.04991Z"
					            fill="black" />
					            <path d="M16.3109 105.689C16.0039 105.412 15.8518 105.205 15.6488 105.103C13.2268 103.898 11.4479 101.953 9.70985 99.96C9.50485 99.724 9.26885 99.465 9.18885 99.177C9.06785 98.738 8.90787 98.2 9.05787 97.82C9.27887 97.266 9.85485 97.515 10.3219 97.603C11.7479 97.873 13.0599 98.323 14.2729 99.205C15.4919 100.092 16.8879 100.73 18.2089 101.473C18.9839 101.909 19.7729 102.17 20.7109 102.112C22.2789 102.016 23.4749 102.688 24.1719 104.163C24.3399 104.515 24.6349 104.808 24.8789 105.122C25.4399 105.849 25.7969 106.579 25.4039 107.554C25.2559 107.923 25.4369 108.427 25.4779 109.033C24.2769 108.762 23.2789 108.537 22.3449 108.327C20.9969 109.16 19.7489 110.016 18.4229 110.727C17.1609 111.403 15.8179 111.926 14.5749 112.487C13.8699 111.966 13.2059 111.532 12.6119 111.016C12.2289 110.682 12.0728 110.155 12.4208 109.722C12.9128 109.105 13.4479 108.496 14.0599 108.004C14.8709 107.353 15.7149 106.758 16.3109 105.689Z"
					            fill="black" />
					            <path d="M49.1802 86.532C49.6552 88.307 50.2012 90.069 49.4182 92.006C47.9752 92.111 46.9712 91.287 46.0572 90.28C45.5362 89.706 45.0282 89.119 44.4832 88.502C43.6042 88.721 42.8542 88.906 42.0202 89.113C41.3502 87.704 42.0082 86.396 41.9362 84.813C41.0822 83.431 40.0862 81.808 39.0812 80.192C38.8272 79.786 38.5153 79.416 38.2823 79C37.7573 78.061 38.2622 77.047 39.3392 76.835C40.2572 76.654 41.1092 76.844 41.7962 77.458C42.4462 78.04 43.0152 78.715 43.6162 79.352C44.2122 79.982 44.6652 80.771 45.6732 81.115C45.8682 80.995 46.2143 80.897 46.3683 80.671C47.3063 79.299 48.6432 79.369 50.0182 79.622C50.9912 79.802 51.8252 80.741 51.9832 81.744C52.0322 82.058 52.0492 82.378 52.1002 82.692C52.2072 83.374 52.0393 83.926 51.4933 84.395C50.7133 85.066 49.9792 85.789 49.1802 86.532Z"
					            fill="black" />
					            <path d="M67.0101 115.141C67.0281 114.983 67.0451 114.825 67.0781 114.52C66.5881 114.52 66.0961 114.557 65.6131 114.502C65.4001 114.479 65.1521 114.313 65.0151 114.136C64.7281 113.767 64.5051 113.348 64.2921 113.008C64.7801 111.246 65.6731 109.895 67.3801 109.008C66.3231 107.477 65.0621 106.319 63.8101 105.217C64.2611 103.867 65.351 103.764 66.369 103.842C67.221 103.906 68.0641 104.25 68.8751 104.565C69.4591 104.794 69.98 105.178 70.58 105.521C71.488 104.877 72.3441 104.182 73.2811 103.627C74.8771 102.682 76.9781 103.578 77.4201 105.334C77.4571 105.48 77.4711 105.715 77.3871 105.795C76.7871 106.361 77.0181 107.047 77.0161 107.722C77.0161 107.998 76.7501 108.287 76.5691 108.544C76.2491 109 75.9011 109.436 75.4791 109.994C75.4791 111.053 75.4791 112.223 75.4791 113.238C74.8111 113.9 74.2801 113.631 73.7881 113.39C72.4381 112.734 71.2221 112.945 69.9761 113.738C69.0501 114.328 68.1031 114.957 66.9531 115.078L67.0101 115.141Z"
					            fill="black" />
					            <path d="M18.5682 79.488C20.3222 82.367 20.4922 83.267 19.5802 85.064C18.3182 84.46 16.9713 84.06 15.8593 83.108C14.8753 82.265 14.1542 82.273 13.0562 82.98C12.7242 83.195 12.4112 83.45 12.1202 83.718C11.4792 84.312 10.7782 84.134 10.1282 83.826C9.54424 83.55 9.48924 82.961 9.58924 82.376C9.72424 81.595 9.75326 80.769 10.0403 80.046C10.5073 78.871 10.3513 77.885 9.57126 76.934C9.37226 76.691 9.19426 76.405 9.10026 76.109C8.91426 75.513 8.62326 74.88 9.17026 74.318C9.62726 73.849 10.2113 73.959 10.7463 74.107C11.1973 74.234 11.6292 74.453 12.0512 74.669C12.4732 74.886 12.8732 75.148 13.4012 75.461C13.8402 75.044 14.2622 74.596 14.7312 74.207C15.6982 73.408 16.7843 72.988 18.0533 73.334C19.0453 73.604 19.6702 74.367 19.7662 75.389C19.9322 77.162 19.8552 77.431 18.5682 79.488Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}		

					if( 'blob_top_right' == $item['layout'] ) {
						echo '
						 	<div class="decoration top right scale-4">
					          <svg class="bg-primary-2" width="298" height="197" viewBox="0 0 298 197" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M271.518 116.857C266.116 125.511 259.584 133.287 253.194 141.164C248.36 147.125 243.548 153.103 238.583 158.953C236.134 161.84 233.362 164.453 230.733 167.185C229.881 168.072 228.921 168.871 228.172 169.833C225.727 172.979 222.572 175.452 220.145 178.651C217.581 182.032 213.84 184.145 210.204 186.288C201.958 191.145 193.024 193.809 183.61 195.366C174.13 196.932 164.633 196.987 155.102 196.749C148.211 196.575 141.723 194.466 135.547 191.72C126.522 187.704 117.201 184.554 107.795 181.695C102.133 179.974 96.211 179.015 90.348 178.072C82.455 176.801 74.483 176.021 66.59 174.748C61.49 173.924 56.395 173.656 51.27 173.844C41.399 174.205 31.62 172.856 21.799 172.319C17.233 172.069 12.623 171.329 8.32199 169.428C3.47399 167.289 0.64998 163.86 0.50198 158.356C0.33398 152.055 1.14497 145.872 2.36097 139.725C4.05597 131.147 6.94698 122.92 9.63998 114.625C11.435 109.1 14.044 104.068 17.138 99.191C20.263 94.261 22.833 88.964 26.156 84.181C28.943 80.169 32.218 76.415 35.73 73.013C39.232 69.62 43.835 67.853 48.488 66.47C49.535 66.159 50.73 66.247 51.851 66.298C56.263 66.493 60.572 67.214 64.898 68.22C71.472 69.749 77.906 72.04 84.709 72.466C87.564 72.646 90.438 72.616 93.301 72.558C98.117 72.46 102.93 72.236 107.746 72.117C113 71.986 117.902 70.75 122.18 67.582C129.756 61.973 137.328 56.355 144.856 50.678C150.336 46.543 155.829 42.416 161.157 38.088C167.837 32.662 174.261 26.918 180.968 21.529C186.708 16.916 192.419 12.265 198.823 8.50796C202.481 6.35996 206.471 5.08997 210.255 3.29897C212.142 2.40397 214.415 2.16795 216.544 1.97295C222.355 1.43795 228.177 0.931955 234.007 0.701955C239.169 0.498955 244.191 1.50895 249.097 3.18795C256.88 5.85395 264.337 9.12595 271.404 13.417C275.808 16.089 280.133 18.696 283.58 22.601C285.338 24.591 287.455 26.2709 289.187 28.2829C296.781 37.0899 298.767 47.203 296.302 58.465C295.044 64.211 293.189 69.723 290.986 75.139C287.625 83.399 284.443 91.746 280.726 99.846C278.041 105.691 274.613 111.197 271.518 116.857ZM95.393 132.113C95.569 132.066 95.745 132.021 95.92 131.974C95.768 131.382 95.617 130.788 95.465 130.197C95.283 130.244 95.102 130.291 94.922 130.338C95.078 130.93 95.236 131.521 95.393 132.113ZM225.68 158.404C225.83 158.343 225.985 158.293 226.121 158.211C226.142 158.199 226.103 157.986 226.062 157.977C225.916 157.94 225.755 157.948 225.601 157.938C225.627 158.092 225.652 158.248 225.68 158.404Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}	

					if( 'blob_left' == $item['layout'] ) {
						echo '
						 	<div class="decoration middle-y left scale-4" data-aos="fade-right">
					          <svg class="bg-primary-2" width="184" height="81" viewBox="0 0 184 81" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M106.27 57.509C107.217 57.164 108.159 56.534 109.112 56.514C131.21 56.053 153.307 55.655 175.405 55.26C176.436 55.241 177.485 55.2749 178.501 55.4339C181.522 55.9059 183.179 57.506 183.296 59.944C183.441 62.993 181.905 65.768 179.353 66.506C177.207 67.125 174.972 67.5199 172.748 67.7829C165.721 68.6189 158.678 69.3429 151.643 70.1189C150.801 70.2129 149.967 70.369 148.973 70.519C148.42 71.853 148.049 73.185 147.356 74.32C146.35 75.97 145.002 76.9309 142.811 77.1789C129.262 78.7099 115.709 79.878 102.051 79.743C94.852 79.673 87.647 80.113 80.442 80.155C78.249 80.168 76.051 79.3679 73.854 79.3699C58.645 79.3799 43.624 77.3949 28.614 75.2739C21.452 74.2619 14.298 73.169 7.16705 71.962C2.85304 71.233 0.98504 69.2959 0.67704 65.7789C0.41504 62.8019 1.99504 60.763 4.96604 60.406C5.98404 60.283 7.03203 60.427 8.06803 60.463C15.099 60.706 22.132 60.9529 29.246 60.7839C26.967 60.4059 24.685 60.049 22.412 59.644C20.898 59.373 19.318 59.238 17.906 58.687C14.812 57.48 14.162 55.958 14.906 52.528C15.541 49.603 16.82 48.607 20.008 48.556C24.824 48.48 29.643 48.404 34.315 48.329C34.555 47.587 34.848 47.089 34.737 46.97C31.716 43.749 30.706 39.074 26.985 36.35C25.243 35.074 24.897 33.1589 25.481 31.2279C26.059 29.3219 27.395 27.9259 29.452 27.5409C31.118 27.2289 32.815 27.0829 34.556 26.8559C35.038 24.1809 33.949 22.627 31.806 21.777C24.55 18.896 23.81 16.9359 24.931 10.3129C23.88 9.36394 22.745 8.33794 21.464 7.17994C21.505 6.28094 21.585 5.25796 21.593 4.23396C21.611 2.26896 22.779 1.44394 24.54 1.34294C29.702 1.04794 34.888 0.391959 40.028 0.638959C51.753 1.20096 63.444 2.41096 75.167 2.99696C89.489 3.71296 103.829 4.05895 118.161 4.56395C126.96 4.87495 135.763 5.10595 144.556 5.55995C146.368 5.65295 148.41 6.18895 149.867 7.20695C152.109 8.77295 154.41 9.34295 157.053 9.66395C159.352 9.94295 161.547 11.075 164.133 11.946C163.488 15.223 162.938 18.025 162.309 21.234C163.909 21.448 165.395 21.697 166.891 21.829C167.918 21.92 168.969 21.7809 169.998 21.8649C173.602 22.1599 175.807 23.5679 176.049 25.6579C176.416 28.8279 174.061 31.74 170.502 32.515C165.959 33.504 165.959 33.504 164.998 38.858C166.56 38.929 168.082 38.9539 169.598 39.0759C172.922 39.3429 174.436 40.5219 174.766 43.0159C175.245 46.6299 173.711 49.55 170.557 50.302C167.039 51.142 163.461 51.9369 159.866 52.2179C143.854 53.4649 127.827 54.5169 111.807 55.6539C109.809 55.7969 107.543 55.223 106.27 57.523C104.791 55.748 103.09 56.222 101.452 56.902C103.002 57.101 104.635 57.305 106.27 57.509ZM152.543 38.5669C152.533 38.9539 152.522 39.3399 152.512 39.7269C154.104 39.6279 155.696 39.529 157.287 39.431C157.291 39.304 157.295 39.176 157.299 39.048C155.715 38.888 154.129 38.7279 152.543 38.5669ZM162.824 38.9179C162.697 38.8329 162.572 38.685 162.443 38.681C162.298 38.677 162.152 38.806 162.005 38.876C162.193 39.021 162.38 39.1649 162.567 39.3089C162.652 39.1789 162.738 39.0489 162.824 38.9179ZM113.043 20.75L112.957 20.466L112.6 20.627L113.043 20.75Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}

					if( 'blob_bottom_right' == $item['layout'] ) {
						echo '
						 	<div class="decoration bottom right scale-2" data-jarallax-element="20">
					          <svg class="bg-primary" width="164" height="179" viewBox="0 0 164 179" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M163.549 87.288C163.994 91.559 163.58 95.773 163.129 99.99C162.9 102.135 162.93 104.322 162.525 106.429C161.322 112.704 160 118.958 158.65 125.204C157.656 129.811 156.554 134.395 155.482 138.987C155.027 140.932 154.529 142.866 154.046 144.805C152.794 149.85 151.591 154.909 150.265 159.934C149.654 162.248 148.911 164.543 148.029 166.768C146.922 169.563 145.058 171.887 142.802 173.846C141.974 174.565 140.95 175.227 139.909 175.502C136.128 176.5 132.311 177.371 128.483 178.176C127.413 178.401 126.256 178.209 125.139 178.237C123.637 178.274 122.135 178.374 120.633 178.382C119.278 178.39 117.922 178.251 116.569 178.286C112.09 178.401 107.624 178.432 103.206 177.464C102.44 177.296 101.606 177.308 100.821 177.398C99.5319 177.544 98.3209 177.359 97.0439 177.138C94.9439 176.775 92.7689 176.878 90.6419 176.64C85.7179 176.085 80.7589 175.695 75.9019 174.773C70.1659 173.683 64.5059 172.019 59.5539 168.818C55.6089 166.269 52.5809 162.695 50.8099 158.279C48.8939 153.502 48.1109 148.41 47.2649 143.371C46.2489 137.309 45.4989 131.201 44.6909 125.105C44.1989 121.382 43.9939 117.615 43.3409 113.923C42.5479 109.443 41.5399 104.991 40.4019 100.585C39.4219 96.796 38.2689 93.038 36.9269 89.361C35.8079 86.292 34.3699 83.329 32.9579 80.375C30.8229 75.908 28.6569 71.455 26.3739 67.063C24.8639 64.157 23.1609 61.349 21.4809 58.536C19.1039 54.56 16.7059 50.598 14.2489 46.673C12.1749 43.358 9.93488 40.145 7.89488 36.809C5.84788 33.459 4.26588 29.865 3.06488 26.133C2.15888 23.32 1.29189 20.466 0.765885 17.566C-0.168115 12.406 0.775877 7.64902 4.91988 4.03802C7.21688 2.03802 10.0999 1.13203 13.0779 0.897028C16.5759 0.622028 20.0989 0.663015 23.6109 0.559015C24.7299 0.526015 25.8469 0.434018 26.9659 0.430018C31.1159 0.412018 35.2669 0.453031 39.4169 0.406031C41.6509 0.380031 43.8859 0.227015 46.1179 0.115015C51.0929 -0.133985 56.0129 0.390013 60.9189 1.11901C64.5519 1.65901 68.1889 2.16104 71.8149 2.73004C73.4689 2.98904 75.0979 3.41101 76.7529 3.67501C78.0909 3.88901 79.4459 4.07103 80.7959 4.10003C82.3099 4.13203 83.8169 3.86701 85.0519 5.16201C85.3269 5.45101 86.1029 5.38301 86.6179 5.29601C87.9579 5.07301 89.2759 4.72701 90.6099 4.46801C92.5509 4.09101 94.2509 4.55204 95.6589 5.99304C97.1099 7.47904 98.6079 8.92202 100.046 10.422C104.025 14.575 107.849 18.888 111.985 22.877C117.036 27.749 122.268 32.443 127.569 37.043C130.52 39.602 133.807 41.767 136.872 44.199C138.681 45.636 140.356 47.243 142.081 48.788C142.733 49.374 143.311 50.051 143.991 50.604C148.378 54.179 151.79 58.587 154.946 63.231C158.069 67.829 160.684 72.684 162.016 78.098C162.76 81.105 163.055 84.221 163.549 87.288ZM88.3849 25.021C89.2389 25.402 89.8909 25.693 90.5409 25.984C90.6819 25.863 90.8199 25.742 90.9589 25.621C90.7789 25.102 90.7499 24.392 90.3869 24.104C89.6969 23.557 89.1049 24.066 88.3849 25.021ZM124.295 81.648C124.119 81.871 123.893 82.035 123.883 82.212C123.875 82.339 124.254 82.623 124.289 82.598C124.504 82.443 124.672 82.22 124.855 82.019C124.684 81.907 124.514 81.793 124.295 81.648ZM70.0289 163.215C69.9469 163.336 69.8649 163.457 69.7829 163.578C70.1249 163.808 70.4669 164.039 70.8079 164.269C70.8899 164.148 70.9719 164.027 71.0539 163.906C70.7129 163.676 70.3709 163.445 70.0289 163.215ZM78.8279 54.925C78.7539 55.035 78.6189 55.15 78.6249 55.255C78.6329 55.375 78.7679 55.487 78.8479 55.603C78.9529 55.455 79.0569 55.306 79.1619 55.157C79.0509 55.08 78.9389 55.002 78.8279 54.925ZM116.932 164.01C116.821 163.922 116.709 163.832 116.596 163.744C116.522 163.904 116.446 164.066 116.369 164.226C116.502 164.273 116.648 164.372 116.764 164.345C116.842 164.328 116.879 164.129 116.932 164.01Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}	

					if( 'lines_bottom_right_small' == $item['layout'] ) {
						echo '
						 	<div class="decoration bottom right" data-jarallax-element="-50">
					          <svg class="bg-white" width="193" height="262" viewBox="0 0 193 262" fill="none" xmlns="http://www.w3.org/2000/svg">
					            <path d="M12.5043 34.1189C11.9323 32.8069 12.5433 32.2089 13.4243 32.0389C14.7033 31.7929 16.0243 31.7339 17.3303 31.6679C21.3653 31.4609 25.4063 31.0839 29.4353 31.6949C30.4843 31.8549 31.5113 32.1789 32.5353 32.4779C34.1293 32.9449 34.8463 34.0519 34.7543 35.8669C34.2213 35.8669 33.6253 36.0149 33.1413 35.8439C30.4093 34.8789 27.6103 34.5259 24.7213 34.4979C20.6893 34.4569 16.6603 34.2559 12.5043 34.1189Z"
					            fill="black" />
					            <path d="M37.8091 4.28699C39.3601 3.37899 40.1161 2.66001 40.9911 2.46701C45.8841 1.38101 50.8291 0.67999 55.8681 0.93399C56.7781 0.98099 57.4701 1.288 57.8881 2.147C58.3001 2.997 57.818 4.02601 56.943 3.99701C51.216 3.81101 45.5451 4.597 39.8491 4.948C39.4511 4.971 39.0351 4.69699 37.8091 4.28699Z"
					            fill="black" />
					            <path d="M33.0607 21.543C30.9257 21.543 28.7907 21.561 26.6587 21.529C26.0787 21.521 25.4887 21.404 24.9247 21.256C24.3677 21.11 24.1707 20.096 24.6537 19.805C25.2477 19.444 25.8877 19.041 26.5517 18.932C30.5557 18.27 34.5907 17.916 38.6477 18.243C39.5717 18.317 40.5307 18.585 41.3547 18.997C41.7707 19.204 42.1207 19.925 42.1497 20.433C42.1867 21.101 41.5757 21.394 40.9157 21.396C38.2987 21.4 35.6797 21.396 33.0617 21.396C33.0607 21.445 33.0607 21.494 33.0607 21.543Z"
					            fill="black" />
					            <path d="M113.391 190.953C113.391 191.92 113.391 192.715 113.391 193.435C113.008 193.597 112.787 193.785 112.594 193.759C108.352 193.224 104.106 192.695 99.9317 191.739C99.1507 191.559 98.3727 191.18 97.7107 190.725C97.2147 190.383 96.9917 189.678 97.4277 189.145C97.6857 188.827 98.2517 188.551 98.6467 188.592C99.9417 188.721 101.215 189.041 102.508 189.217C105.227 189.586 107.957 189.883 110.674 190.27C111.596 190.404 112.492 190.723 113.391 190.953Z"
					            fill="black" />
					            <path d="M20.3047 166.006C20.3397 164.66 20.8087 163.992 21.5647 164.037C24.8697 164.24 28.2037 162.975 31.4907 164.273C32.0027 164.476 32.6407 164.337 33.2197 164.394C34.2667 164.496 35.3117 164.626 36.2277 164.732C36.9287 165.836 37.6337 166.681 36.8917 168.082C31.4407 167.4 25.9317 166.711 20.3047 166.006Z"
					            fill="black" />
					            <path d="M9.80322 44.908C10.9752 44.617 11.7722 44.1931 12.5142 44.2731C16.6432 44.7161 20.7622 45.2731 24.8792 45.8201C25.3342 45.8811 25.8442 46.027 26.1912 46.306C26.7752 46.771 27.0272 47.441 26.7302 48.202C26.4762 48.847 25.9532 49.097 25.3122 48.975C20.6502 48.09 15.9882 47.2091 11.3392 46.2521C10.8792 46.1581 10.5232 45.559 9.80322 44.908Z"
					            fill="black" />
					            <path d="M30.9082 261.238C28.1032 260.871 25.1372 260.486 22.1722 260.09C20.6352 259.885 19.0922 259.699 17.5702 259.406C17.1952 259.334 16.8922 258.879 16.5562 258.597C16.8492 258.261 17.0812 257.742 17.4472 257.622C18.3362 257.329 19.3042 256.997 20.2052 257.079C24.1392 257.436 28.0592 257.923 31.9802 258.397C32.4332 258.452 32.9602 258.618 33.2752 258.918C33.5782 259.207 33.8322 259.772 33.7652 260.156C33.7042 260.506 33.2342 260.924 32.8572 261.049C32.3072 261.232 31.6802 261.178 30.9082 261.238Z"
					            fill="black" />
					            <path d="M96.5059 205.322C97.4199 203.849 98.3259 203.453 99.4959 203.752C102.957 204.637 106.449 205.262 110.043 205.209C110.598 205.201 111.238 205.424 111.688 205.75C111.997 205.975 112.209 206.588 112.149 206.98C112.094 207.345 111.659 207.886 111.327 207.937C110.044 208.136 108.716 208.369 107.44 208.23C104.042 207.861 100.682 207.212 97.4629 206C97.1449 205.881 96.8869 205.6 96.5059 205.322Z"
					            fill="black" />
					            <path d="M145.586 86.619C141.428 86.431 137.268 86.267 133.113 86.039C132.287 85.994 131.467 85.736 130.66 85.523C129.777 85.289 129.293 84.679 129.463 84.043C129.656 83.322 130.227 83.232 130.867 83.287C131.582 83.348 132.299 83.412 133.013 83.432C134.562 83.473 136.109 83.498 137.658 83.506C139.558 83.516 141.465 83.412 143.359 83.526C145.215 83.639 145.854 84.635 145.586 86.619Z"
					            fill="black" />
					            <path d="M118.27 119.072C117.411 119.205 116.84 119.351 116.266 119.369C112.217 119.498 108.186 119.24 104.215 118.463C102.858 118.199 101.574 117.494 100.309 116.881C100.073 116.766 100.094 116.125 99.9443 115.516C102.786 115.795 105.36 115.987 107.917 116.317C110.384 116.635 112.812 117.198 115.343 116.893C116.105 116.803 116.995 117.118 117.697 117.489C118.025 117.662 118.051 118.414 118.27 119.072Z"
					            fill="black" />
					            <path d="M133.695 117.254C133.361 115.541 133.931 114.736 135.222 114.621C137.124 114.451 139.036 114.42 140.945 114.328C142.129 114.269 143.314 114.131 144.494 114.168C145.797 114.207 147.129 114.27 148.377 114.598C148.936 114.744 149.42 115.5 149.758 116.086C150.141 116.748 149.529 117.654 148.795 117.594C145.461 117.319 142.106 117.164 138.807 116.658C137.064 116.391 135.527 116.916 133.695 117.254Z"
					            fill="black" />
					            <path d="M24.2108 239.361C23.9408 238.166 24.7698 237.683 25.5528 237.625C29.7008 237.316 33.8458 237.32 37.9258 238.313C38.1528 238.368 38.3828 238.456 38.5798 238.581C39.1208 238.921 39.5098 239.431 39.2258 240.046C39.0658 240.394 38.5599 240.804 38.2099 240.802C36.3169 240.798 34.4208 240.734 32.5358 240.579C30.0558 240.376 27.5808 240.087 25.1078 239.796C24.7868 239.758 24.4898 239.502 24.2108 239.361Z"
					            fill="black" />
					            <path d="M4.02708 185.873C7.21508 186.008 9.68508 186.07 12.1481 186.24C12.9641 186.297 13.7731 186.594 14.5641 186.844C15.7651 187.225 16.1481 188.19 16.2031 189.34C16.2381 190.094 15.4671 190.764 14.7691 190.467C11.2031 188.951 7.34308 189.022 3.62408 188.342C3.05008 188.237 2.48309 188.047 1.94009 187.832C1.75609 187.76 1.51808 187.459 1.54508 187.305C1.59808 186.987 1.74809 186.512 1.97709 186.432C2.86509 186.117 3.79908 185.932 4.02708 185.873Z"
					            fill="black" />
					            <path d="M94.7891 219.41C97.0781 218.035 99.082 217.969 101.291 218.488C103.371 218.978 105.561 218.974 107.684 219.312C109.526 219.605 109.686 219.929 109.776 222.283C106.445 222.646 97.9841 221.08 94.7891 219.41Z" fill="black" />
					            <path d="M105.479 258.533C100.325 259.467 95.2289 258.387 89.8149 259.236C90.1199 258.408 90.1699 257.793 90.5029 257.484C90.9989 257.023 91.683 256.517 92.308 256.488C96.226 256.302 100.148 256.211 104.07 256.185C104.539 256.183 105.127 256.691 105.439 257.121C105.65 257.414 105.479 257.986 105.479 258.533Z"
					            fill="black" />
					            <path d="M13.4198 132.031C9.34175 131.353 5.46075 130.728 1.59175 130.043C1.19175 129.971 0.636743 129.602 0.550743 129.268C0.464743 128.938 0.786752 128.356 1.10376 128.106C1.55076 127.751 2.17775 127.358 2.69775 127.399C5.78975 127.635 8.87975 127.954 11.9558 128.346C12.4808 128.412 13.0438 128.883 13.4128 129.317C14.0818 130.105 14.2788 131.018 13.4198 132.031Z"
					            fill="black" />
					            <path d="M95.9939 175.424C100.695 174.828 104.971 176.781 109.349 177.834C109.974 179.416 109.974 179.416 109.646 180.836C109.431 180.889 109.185 181.039 109.003 180.981C106.091 180.053 103.011 179.69 100.271 178.139C99.2999 177.59 97.9509 177.76 96.8119 177.455C95.8909 177.207 95.4449 176.555 95.9939 175.424Z"
					            fill="black" />
					            <path d="M20.3222 105.275C21.5932 104.572 23.0722 104.556 24.4162 104.781C26.7542 105.17 29.0312 105.908 31.3462 106.453C32.4162 106.707 32.9032 107.519 33.2852 108.383C33.4472 108.75 33.4282 109.389 33.2032 109.684C32.9822 109.973 32.3612 110.163 31.9742 110.088C30.6912 109.842 29.4292 109.481 28.1712 109.121C26.1102 108.533 24.0542 107.928 22.0052 107.299C21.0722 107.012 20.1822 106.631 20.3222 105.275Z"
					            fill="black" />
					            <path d="M51.6641 70.967C52.1721 69.502 53.4491 69.529 54.3961 69.371C57.1341 68.916 59.8691 69.402 62.5331 70.027C63.2031 70.185 63.775 71.05 64.244 71.699C64.662 72.275 64.0661 73.256 63.3141 73.226C61.5291 73.162 59.7321 73.0989 57.9661 72.8469C56.1981 72.5929 54.454 72.144 52.718 71.708C52.324 71.609 52.0021 71.215 51.6641 70.967Z"
					            fill="black" />
					            <path d="M97.8091 157.562C99.1841 157.681 100.579 157.707 101.938 157.937C104.622 158.394 107.29 158.951 109.958 159.494C110.409 159.586 110.929 159.715 111.241 160.01C111.54 160.291 111.8 160.85 111.731 161.223C111.663 161.592 111.211 161.957 110.842 162.186C110.565 162.356 110.147 162.37 109.801 162.346C105.877 162.073 102.031 161.438 98.4511 159.696C97.6371 159.299 97.6501 159.27 97.8091 157.562Z"
					            fill="black" />
					            <path d="M4.69493 201.521C6.87693 202.087 9.77492 202.796 12.6459 203.603C13.9449 203.968 15.0479 204.74 15.5989 206.027C15.7449 206.369 15.5739 206.947 15.3589 207.302C15.2339 207.511 14.6789 207.654 14.4139 207.558C10.7189 206.232 7.03892 204.863 3.35892 203.49C3.14592 203.412 2.91593 203.25 2.79793 203.062C2.62793 202.791 2.40292 202.41 2.47992 202.164C2.56392 201.898 2.94293 201.684 3.23993 201.539C3.43393 201.447 3.70693 201.521 4.69493 201.521Z"
					            fill="black" />
					            <path d="M41.4259 130.395C42.6169 130.395 43.8109 130.362 44.9999 130.405C46.0139 130.44 46.8649 130.882 47.3649 131.782C47.5759 132.165 47.7219 132.684 47.6559 133.102C47.5349 133.832 46.8549 133.93 46.2559 133.883C43.8829 133.695 41.5159 133.461 39.1449 133.254C37.8399 133.139 36.5239 133.096 35.2329 132.897C34.8889 132.844 34.5099 132.379 34.3579 132.016C34.2819 131.836 34.6259 131.278 34.8809 131.194C36.6559 130.608 38.3629 129.604 40.3629 130.132C40.7049 130.222 41.0719 130.22 41.4269 130.261C41.4279 130.305 41.4259 130.35 41.4259 130.395Z"
					            fill="black" />
					            <path d="M56.6558 253.836C56.8978 251.44 57.8118 250.256 59.3448 249.77C62.7858 248.676 66.3508 248.536 69.9308 248.846C70.3668 248.883 70.8718 249.131 71.1748 249.446C71.4658 249.751 71.7258 250.301 71.6538 250.678C71.5878 251.032 71.1168 251.424 70.7358 251.571C70.3198 251.731 69.8018 251.635 69.3298 251.637C67.5488 251.645 65.7658 251.631 63.9818 251.657C61.5798 251.691 59.2678 252.119 56.6558 253.836Z"
					            fill="black" />
					            <path d="M60.691 239.217C60.644 238.789 60.515 238.483 60.613 238.369C62.203 236.508 64.095 235.098 66.609 234.853C68.498 234.669 70.4 234.619 72.298 234.564C72.759 234.55 73.234 234.728 73.687 234.871C74.685 235.187 75.21 235.857 75.119 236.641C75.035 237.381 74.336 237.76 73.178 237.579C69.313 236.972 65.602 237.518 61.99 238.96C61.594 239.117 61.137 239.131 60.691 239.217Z"
					            fill="black" />
					            <path d="M118.623 21.479C119.576 21.405 120.535 21.377 121.48 21.245C122.601 21.087 123.281 21.737 123.918 22.464C124.529 23.163 124.137 24.212 123.18 24.349C120.815 24.683 118.45 25.042 116.043 24.73C114.512 24.531 112.963 24.474 111.439 24.232C111.068 24.173 110.564 23.673 110.505 23.314C110.452 23.002 110.886 22.351 111.204 22.277C112.821 21.898 114.464 21.611 116.11 21.386C116.932 21.273 117.782 21.366 118.62 21.366C118.621 21.402 118.623 21.441 118.623 21.479Z"
					            fill="black" />
					            <path d="M147.104 103C144.204 102.354 141.684 101.707 139.131 101.246C136.705 100.808 134.244 100.568 131.854 100.248C131.483 99.2499 131.961 98.654 132.7 98.531C133.862 98.338 135.085 98.226 136.247 98.371C139.196 98.736 142.142 99.1799 145.056 99.7579C146.695 100.084 146.795 100.414 147.104 103Z"
					            fill="black" />
					            <path d="M110.34 128.545C111.024 129.723 111.031 130.203 110.379 130.578C108.682 131.555 106.764 131.746 104.893 132.004C103.493 132.197 102.043 132.158 100.627 132.057C99.9589 132.01 99.2459 131.676 98.6929 131.278C98.4059 131.071 98.3119 130.436 98.3389 130.008C98.3569 129.752 98.7449 129.36 99.0209 129.307C100.298 129.065 101.589 128.828 102.886 128.76C105.367 128.627 107.855 128.609 110.34 128.545Z"
					            fill="black" />
					            <path d="M32.8589 194.584C34.4309 193.139 35.7129 192.869 37.0189 192.922C40.0969 193.045 43.1749 193.221 46.2419 193.506C46.8419 193.563 47.4959 194.111 47.9299 194.606C48.3769 195.116 48.8049 195.911 48.1589 196.508C47.7999 196.84 47.0709 196.985 46.5609 196.901C44.9259 196.631 43.2909 196.301 41.7059 195.833C39.5149 195.183 37.3019 194.895 35.0259 194.944C34.4919 194.953 33.9529 194.773 32.8589 194.584Z"
					            fill="black" />
					            <path d="M77.8257 187.73C76.8787 187.591 75.5857 187.447 74.3097 187.209C72.4527 186.865 70.6067 186.455 68.7567 186.068C68.6437 186.045 68.5397 185.976 68.4287 185.943C67.7487 185.74 67.2467 185.101 67.5307 184.689C67.7747 184.335 68.2127 183.878 68.5637 183.877C69.8567 183.873 71.1987 183.859 72.4347 184.18C74.7647 184.778 77.1007 184.875 79.4717 184.799C79.9387 184.783 80.4327 184.783 80.8697 184.92C81.4827 185.111 81.8837 185.623 81.7387 186.27C81.6487 186.674 81.3207 187.249 80.9927 187.332C80.0897 187.568 79.1267 187.586 77.8257 187.73Z"
					            fill="black" />
					            <path d="M126.467 67.6349C122.076 67.3399 117.873 66.8519 113.526 65.2089C113.965 64.6189 114.202 64.0039 114.467 63.9899C117.91 63.8199 121.358 63.5879 124.795 64.1229C126.024 64.3139 126.699 65.0779 126.863 66.2419C126.92 66.6459 126.631 67.0979 126.467 67.6349Z"
					            fill="black" />
					            <path d="M126.869 174.398C127.851 173.154 129.346 173.238 130.521 173.281C133.226 173.379 135.923 173.842 138.607 174.261C139.744 174.439 139.898 174.896 139.849 176.724C137.537 177.603 135.169 176.976 132.865 176.708C131.01 176.491 129.207 175.794 127.402 175.239C127.156 175.166 127.037 174.68 126.869 174.398Z"
					            fill="black" />
					            <path d="M32.857 224.74C29.494 225.193 26.304 225.041 23.128 224.41C22.198 224.226 21.288 223.939 20.36 223.742C19.708 223.605 19.149 223.289 19.288 222.605C19.358 222.259 19.915 221.921 20.323 221.759C20.749 221.591 21.264 221.571 21.733 221.605C24.946 221.835 28.157 222.084 31.364 222.359C32.473 222.453 33.086 223.025 32.857 224.74Z"
					            fill="black" />
					            <path d="M151.867 35.76C149.629 36.049 147.314 36.385 144.992 36.635C143.115 36.838 141.228 36.965 139.342 37.063C139.061 37.077 138.557 36.79 138.512 36.569C138.43 36.167 138.465 35.559 138.717 35.307C139.108 34.92 139.697 34.643 140.248 34.528C142.682 34.024 145.117 33.485 147.58 33.188C148.703 33.051 149.928 33.317 151.039 33.635C151.904 33.881 152.332 34.637 151.867 35.76Z"
					            fill="black" />
					            <path d="M48.7769 59.684C47.6809 60.002 47.0289 60.381 46.3999 60.344C43.0739 60.145 39.7499 59.864 36.4289 59.561C35.5849 59.483 35.0659 58.786 35.1869 58.118C35.3369 57.278 35.9579 56.905 36.6969 56.856C37.8769 56.776 39.0879 56.676 40.2439 56.856C42.4649 57.202 44.6679 57.68 46.8459 58.233C47.4259 58.379 47.8889 58.994 48.7769 59.684Z"
					            fill="black" />
					            <path d="M159.936 60.176C159.366 61.694 157.977 62.285 156.602 62.455C152.977 62.9 149.325 63.148 145.678 63.404C144.522 63.486 143.41 63.144 141.768 62.347C142.805 62.091 143.2 61.915 143.598 61.908C148.496 61.806 153.244 60.869 157.901 59.396C158.77 59.123 159.541 59.061 159.936 60.176Z"
					            fill="black" />
					            <path d="M165.689 89.529C164.679 90.013 163.492 89.945 162.326 89.929C160.299 89.9 158.269 89.884 156.25 89.747C155.447 89.694 154.645 89.39 153.891 89.081C153.641 88.979 153.393 88.493 153.416 88.206C153.437 87.946 153.811 87.526 154.062 87.501C157.019 87.204 159.978 86.903 162.945 86.761C163.707 86.724 164.554 87.132 165.25 87.531C165.91 87.91 166.148 88.617 165.689 89.529Z"
					            fill="black" />
					            <path d="M33.0332 216.92C34.4842 215.449 35.9041 215.693 37.1331 215.672C40.4441 215.615 43.7561 215.776 47.0671 215.885C47.5181 215.901 48.0551 216.012 48.3871 216.283C48.7071 216.545 49.0002 217.09 48.9612 217.474C48.9262 217.82 48.4362 218.376 48.1212 218.394C46.4672 218.482 44.7971 218.531 43.1481 218.4C40.3121 218.171 37.4862 217.812 34.6602 217.476C34.2382 217.426 33.8382 217.201 33.0332 216.92Z"
					            fill="black" />
					            <path d="M62.6932 167.449C61.5782 169.181 59.6951 169.82 57.8861 170.084C54.5171 170.574 51.0792 170.836 47.8652 169.504C47.6832 168.471 48.2712 168.283 48.8632 168.254C50.1642 168.186 51.4782 168.287 52.7732 168.168C55.3692 167.926 57.9862 167.732 60.3782 166.51C61.4102 165.982 62.1762 166.266 62.6932 167.449Z"
					            fill="black" />
					            <path d="M60.4179 46.572C56.7749 46.252 53.3559 45.976 49.9409 45.633C49.0109 45.539 47.9959 45.397 47.7319 43.99C48.1679 43.742 48.6439 43.242 49.1379 43.222C51.9879 43.113 54.8409 43.083 57.6929 43.097C58.9449 43.103 60.0969 43.515 60.5329 44.835C60.6879 45.309 60.4749 45.9 60.4179 46.572Z"
					            fill="black" />
					            <path d="M110.531 9.23401C112.201 9.37901 113.527 9.40399 114.814 9.63599C115.73 9.79999 116.668 10.13 117.459 10.613C117.861 10.857 118.168 11.603 118.15 12.109C118.129 12.742 117.498 13.058 116.843 13.078C116.366 13.092 115.876 13.121 115.413 13.031C112.606 12.486 109.8 11.939 107.011 11.31C106.657 11.232 106.21 10.705 106.156 10.333C106.041 9.56901 106.767 9.403 107.33 9.263C107.783 9.152 108.273 9.154 108.748 9.159C109.463 9.166 110.178 9.21701 110.531 9.23401Z"
					            fill="black" />
					            <path d="M78.6407 146.537C74.2737 146.828 69.9217 146.939 65.6677 145.543C65.2067 145.391 64.6797 145.143 64.8747 144.615C64.9997 144.279 65.5287 143.927 65.9097 143.885C66.8477 143.78 67.8138 143.756 68.7518 143.867C71.4688 144.185 74.1658 144.517 76.9198 144.185C78.3748 144.01 78.7247 144.582 78.6407 146.537Z"
					            fill="black" />
					            <path d="M133.164 127.447C133.262 126.758 133.174 126.187 133.406 125.984C133.82 125.625 134.422 125.306 134.957 125.287C137.209 125.203 139.465 125.195 141.717 125.244C142.889 125.267 144.067 125.41 145.225 125.603C145.782 125.697 146.389 125.931 146.799 126.296C147.084 126.55 147.186 127.144 147.154 127.569C147.136 127.811 146.715 128.147 146.424 128.215C145.856 128.352 145.244 128.408 144.664 128.356C143.244 128.227 141.793 128.165 140.426 127.807C138.117 127.203 135.822 126.82 133.164 127.447Z"
					            fill="black" />
					            <path d="M68.9321 122.133C69.1781 120.733 70.2151 120.518 71.1211 120.428C73.2521 120.215 75.4001 120.151 77.5431 120.069C78.7011 120.026 79.6171 120.538 80.2601 121.507C80.7231 122.204 80.2581 123.382 79.4461 123.495C78.8621 123.577 78.2601 123.577 77.6671 123.556C74.6891 123.449 71.8111 122.791 68.9321 122.133Z"
					            fill="black" />
					            <path d="M101.545 76.5291C104.262 76.6481 106.977 76.7501 109.691 76.9001C110.279 76.9331 110.921 77.0271 111.423 77.3021C111.884 77.5541 112.441 78.0541 112.507 78.5091C112.612 79.2611 111.882 79.3941 111.267 79.3661C108.068 79.2291 104.888 78.8251 101.675 78.8581C100.64 78.8701 99.5871 78.4581 98.5701 78.1451C98.3281 78.0691 98.0411 77.6061 98.0621 77.3461C98.0831 77.0881 98.4551 76.6721 98.6991 76.6511C99.6401 76.5711 100.594 76.6201 101.543 76.6201C101.543 76.5901 101.545 76.5611 101.545 76.5291Z"
					            fill="black" />
					            <path d="M29.332 152.154C29.615 151.461 29.686 150.672 30.051 150.494C33.112 149.006 36.19 149.226 39.215 150.674C39.414 150.77 39.613 150.967 39.707 151.166C39.852 151.477 40.076 151.92 39.959 152.141C39.768 152.5 39.33 152.963 38.99 152.971C36.982 153.008 34.969 152.998 32.969 152.86C31.822 152.779 30.693 152.428 29.332 152.154Z"
					            fill="black" />
					            <path d="M121.75 2.96102C122.938 2.26802 123.516 1.63703 124.07 1.65603C126.787 1.74603 129.476 1.51103 132.174 1.29903C132.631 1.26403 133.168 1.29103 133.545 1.50603C133.9 1.70703 134.268 2.17403 134.311 2.56103C134.354 2.93003 134.088 3.48103 133.78 3.71303C133.323 4.05303 132.708 4.36701 132.161 4.36501C129.561 4.35501 126.96 4.28703 124.366 4.11703C123.723 4.07603 123.109 3.58202 121.75 2.96102Z"
					            fill="black" />
					            <path d="M13.0659 120.301C14.2769 120.225 14.9569 120.071 15.6009 120.162C18.2889 120.547 20.9659 120.994 23.6439 121.447C24.0989 121.523 24.6209 121.633 24.9509 121.916C25.2619 122.182 25.5449 122.721 25.4959 123.096C25.4469 123.467 24.9779 123.789 24.6739 124.114C24.6059 124.186 24.4489 124.214 24.3379 124.206C20.5589 123.947 16.6129 123.982 13.0659 120.301Z"
					            fill="black" />
					            <path d="M83.334 60.2251C84.869 58.8771 85.996 58.5261 87.215 58.6121C90.063 58.8111 92.906 59.0811 95.752 59.3071C96.502 59.3681 97.184 59.5711 97.555 60.2601C97.705 60.5391 97.76 60.9811 97.645 61.2601C97.538 61.5221 97.137 61.8481 96.885 61.8321C95.231 61.7301 93.578 61.5781 91.934 61.3751C89.258 61.0451 86.59 60.6621 83.334 60.2251Z"
					            fill="black" />
					            <path d="M103.873 151.232C101.978 151.084 100.781 151.043 99.598 150.88C98.901 150.782 98.2001 150.566 97.5531 150.282C95.9511 149.579 95.225 148.684 95.707 148.1C96.525 147.112 97.459 147.848 98.326 148.036C99.754 148.345 101.14 148.282 102.588 148.081C103.731 147.921 104.961 148.093 106.1 148.354C106.479 148.44 106.829 149.223 106.95 149.745C107.1 150.39 106.669 150.86 106.016 151.036C105.672 151.128 105.315 151.204 104.961 151.224C104.365 151.254 103.768 151.232 103.873 151.232Z"
					            fill="black" />
					            <path d="M128.447 202.484C129.037 201.98 129.424 201.363 129.873 201.312C132.943 200.966 136.025 200.695 139.109 200.525C139.529 200.502 140.121 201.084 140.392 201.531C140.726 202.08 140.511 202.875 139.902 203.015C138.644 203.308 137.318 203.548 136.043 203.468C133.6 203.316 131.055 203.768 128.447 202.484Z"
					            fill="black" />
					            <path d="M96.6577 33.248C97.2787 33.299 97.8847 33.2891 98.4607 33.4081C99.7557 33.6741 101.004 33.6831 102.34 33.5041C103.445 33.3561 104.678 33.7661 105.772 34.1581C106.139 34.2911 106.403 35.1291 106.418 35.6521C106.426 35.9411 105.783 36.5411 105.5 36.5041C102.215 36.0631 98.8357 36.442 95.6227 35.399C95.3997 35.327 95.1267 35.2541 94.9937 35.0881C94.7887 34.8321 94.5247 34.465 94.5777 34.205C94.6387 33.912 94.9797 33.5721 95.2767 33.4571C95.7067 33.2911 96.2087 33.309 96.6577 33.248Z"
					            fill="black" />
					            <path d="M57.0313 21.033C59.9413 21.133 62.0603 22.869 64.4843 23.746C65.5763 24.141 66.5662 24.881 67.5072 25.59C67.7672 25.787 67.8002 26.457 67.7182 26.865C67.6732 27.092 67.1712 27.386 66.8862 27.377C66.1832 27.352 65.4113 27.32 64.7983 27.022C62.4483 25.876 60.1262 24.661 57.8412 23.385C57.1272 22.986 56.5183 22.34 57.0313 21.033Z"
					            fill="black" />
					            <path d="M179.396 92.0231C180.71 91.1991 181.943 91.5681 183.103 91.4121C184.628 91.2071 186.191 91.1371 187.669 90.7521C189.155 90.3651 190.48 90.9281 191.868 91.0941C192.098 91.1211 192.464 91.6491 192.427 91.8951C192.37 92.2781 192.101 92.7391 191.779 92.9481C191.406 93.1881 190.879 93.2801 190.416 93.2861C187.436 93.3251 184.453 93.3331 181.473 93.3331C180.629 93.3301 179.834 93.1781 179.396 92.0231Z"
					            fill="black" />
					            <path d="M94.2441 238.471C94.8691 237.266 95.6831 236.645 96.5391 236.559C99.8591 236.223 103.201 236.098 106.371 237.455C107.291 237.85 107.98 238.488 107.652 239.881C105.494 239.508 103.324 239.117 101.15 238.76C98.9801 238.404 96.7481 238.848 94.2441 238.471Z"
					            fill="black" />
					            <path d="M131.484 158.6C131.211 157.582 131.502 157.002 132.355 156.854C132.933 156.754 133.543 156.764 134.13 156.819C136.958 157.079 139.782 157.366 142.607 157.657C142.834 157.68 143.146 157.731 143.252 157.886C143.506 158.253 143.846 158.71 143.799 159.089C143.758 159.427 143.225 159.993 142.947 159.972C140 159.743 137.058 159.439 134.121 159.109C133.207 159.006 132.309 158.764 131.484 158.6Z"
					            fill="black" />
					            <path d="M123.271 258.295C123.126 256.994 123.914 256.602 124.632 256.256C125.036 256.061 125.562 256.088 126.034 256.068C128.884 255.947 131.733 255.834 134.583 255.738C135.05 255.722 135.612 255.672 135.97 255.894C136.413 256.169 136.868 256.669 136.995 257.156C137.165 257.808 136.647 258.22 135.993 258.355C135.763 258.404 135.524 258.449 135.288 258.445C131.275 258.4 127.262 258.346 123.271 258.295Z"
					            fill="black" />
					            <path d="M68.301 101.959C67.916 101.096 68.246 100.441 69.016 100.258C70.495 99.906 71.946 99.408 73.541 99.6C75.055 99.78 76.602 99.674 78.131 99.735C78.588 99.753 79.092 99.811 79.483 100.022C80.014 100.309 80.44 100.846 80.178 101.477C80.024 101.846 79.557 102.321 79.211 102.336C77.207 102.428 75.193 102.457 73.19 102.387C71.551 102.33 69.918 102.107 68.301 101.959Z"
					            fill="black" />
					            <path d="M127.131 219C127.397 218.471 127.488 217.918 127.787 217.76C129.168 217.033 130.658 216.637 132.225 217.014C133.491 217.319 134.75 217.678 135.973 218.121C136.498 218.31 137.051 218.689 137.36 219.139C137.659 219.575 137.856 220.26 137.739 220.75C137.577 221.438 136.809 221.4 136.243 221.299C135.671 221.195 135.138 220.901 134.579 220.719C132.661 220.102 130.765 219.405 128.704 219.399C128.264 219.396 127.826 219.184 127.131 219Z"
					            fill="black" />
					            <path d="M75.7441 24.383C76.2051 23.406 76.2871 22.807 76.5901 22.658C79.3171 21.322 82.2051 20.685 85.2381 21.088C85.6931 21.149 86.2111 21.729 86.4431 22.197C86.7301 22.769 86.0891 23.541 85.2951 23.676C83.7661 23.938 82.2341 24.233 80.6911 24.358C79.2731 24.473 77.8401 24.383 75.7441 24.383Z"
					            fill="black" />
					            <path d="M175.686 140.355C174.305 141.46 172.887 141.496 171.471 141.306C169.498 141.044 167.532 140.71 165.584 140.304C165.273 140.24 164.813 139.581 164.883 139.318C164.975 138.968 165.498 138.705 165.877 138.472C166.059 138.363 166.365 138.333 166.565 138.404C167.85 138.855 169.163 138.283 170.383 138.465C171.58 138.643 172.651 138.606 173.826 138.434C174.869 138.281 175.51 139.078 175.686 140.355Z"
					            fill="black" />
					            <path d="M157.014 54.381C154.787 54.221 152.559 54.082 150.338 53.871C150.102 53.85 149.756 53.42 149.734 53.156C149.711 52.886 149.961 52.42 150.201 52.332C152.902 51.328 155.689 51 158.5 51.721C159.098 51.873 159.607 52.532 160.055 53.045C160.414 53.457 159.994 54.424 159.481 54.451C158.661 54.496 157.836 54.463 157.012 54.463C157.012 54.436 157.014 54.408 157.014 54.381Z"
					            fill="black" />
					            <path d="M136.078 17.74C137.154 16.974 138.474 16.644 139.889 16.416C141.264 16.195 142.705 16.344 144.01 15.586C144.684 15.193 145.383 15.606 145.893 16.18C146.639 17.024 146.37 18.2 145.327 18.412C143.821 18.721 142.304 19.012 140.776 19.17C139.495 19.303 138.19 19.311 136.905 19.219C136.293 19.176 135.895 18.654 136.078 17.74Z"
					            fill="black" />
					            <path d="M110.469 100.918C110.985 102.205 110.948 102.83 110.235 103.064C106.807 104.193 103.358 104.839 99.9483 103.007C99.6983 102.872 99.3843 102.347 99.4623 102.21C99.6693 101.853 100.066 101.599 100.405 101.329C100.481 101.268 100.639 101.272 100.749 101.298C104.029 102.082 107.281 101.738 110.469 100.918Z"
					            fill="black" />
					            <path d="M144.092 146.182C142.221 145.618 140.647 145.108 139.053 144.67C137.225 144.17 135.385 143.594 133.639 144.621C132.551 143.75 132.951 143.025 133.67 142.482C134.117 142.146 134.764 141.884 135.311 141.904C137.332 141.968 139.358 142.107 141.368 142.334C142.618 142.475 143.559 143.305 144.214 144.313C144.439 144.664 144.164 145.344 144.092 146.182Z"
					            fill="black" />
					            <path d="M126.902 245.607C127.283 245.162 127.5 244.662 127.843 244.548C130.804 243.579 133.888 243.396 136.972 243.271C137.288 243.259 137.63 243.49 137.933 243.66C138.542 244 138.537 245.142 137.921 245.465C137.616 245.625 137.275 245.801 136.944 245.815C133.981 245.934 131.014 246.032 128.049 246.094C127.754 246.102 127.453 245.85 126.902 245.607Z"
					            fill="black" />
					            <path d="M129.209 190.822C132.238 190.377 134.766 189.855 137.316 189.681C139.14 189.556 139.378 190.042 139.519 192.55C136.376 192.925 133.257 192.79 130.16 192.116C129.926 192.064 129.777 191.617 129.209 190.822Z" fill="black" />
					            <path d="M72.502 76.393C72.865 75.778 72.9959 75.239 73.3109 75.094C73.9359 74.803 74.6629 74.584 75.3439 74.592C77.1349 74.61 78.936 74.688 80.713 74.901C81.498 74.997 82.2929 75.389 82.9729 75.821C83.2559 76.003 83.44 76.708 83.321 77.053C83.198 77.405 82.6689 77.647 82.2739 77.86C82.0879 77.962 81.8009 77.922 81.5689 77.885C78.6539 77.412 75.742 76.928 72.502 76.393Z"
					            fill="black" />
					            <path d="M46.277 149.529C47.103 149.482 47.9531 149.537 48.7521 149.365C50.1351 149.064 51.008 149.816 51.826 150.685C52.025 150.896 52.109 151.378 52.014 151.656C51.918 151.935 51.557 152.156 51.266 152.326C51.077 152.435 50.809 152.424 50.573 152.433C47.831 152.554 45.223 151.703 42.561 151.255C42.264 151.206 41.85 150.56 41.881 150.226C41.912 149.894 42.414 149.374 42.748 149.343C43.914 149.234 45.098 149.302 46.275 149.302C46.275 149.377 46.277 149.453 46.277 149.529Z"
					            fill="black" />
					            <path d="M75.1603 164.926C76.4593 164.926 77.7623 164.869 79.0563 164.942C80.3373 165.012 80.8413 165.948 81.1033 167.061C81.2423 167.655 80.7223 168.387 80.1773 168.28C77.5113 167.751 74.8473 167.212 72.2023 166.589C71.9193 166.521 71.6733 165.888 71.6123 165.485C71.5873 165.307 72.0512 164.885 72.3172 164.864C73.2582 164.786 74.2123 164.835 75.1593 164.835C75.1603 164.863 75.1603 164.895 75.1603 164.926Z"
					            fill="black" />
					            <path d="M87.5449 6.66199C86.7379 6.59799 86.0219 6.57801 85.3159 6.47601C84.4959 6.35701 83.7649 5.57601 84.0599 5.07001C84.3199 4.62101 84.8759 4.11899 85.3509 4.06399C86.8819 3.88599 88.4369 3.94499 89.9759 3.82999C90.9209 3.75999 91.8509 3.46501 92.7959 3.42001C93.1789 3.40201 93.7489 3.68201 93.9369 4.00201C94.2889 4.60401 93.9329 5.23401 93.3569 5.47101C92.3749 5.87101 91.3409 6.17801 90.3019 6.38901C89.3729 6.57601 88.4079 6.58199 87.5449 6.66199Z"
					            fill="black" />
					            <path d="M26.877 87.592C27.299 86.293 28.065 86.039 28.895 85.86C31.194 85.362 33.331 86.178 35.5 86.69C35.795 86.76 36.096 87.098 36.248 87.391C36.394 87.67 36.4629 88.088 36.3589 88.371C36.2569 88.646 35.877 89.037 35.654 89.016C32.746 88.742 29.766 88.857 26.877 87.592Z"
					            fill="black" />
					            <path d="M120.842 48.486C121.809 48.111 122.42 47.623 122.867 47.742C124.863 48.283 126.894 47.834 128.879 48.129C129.408 48.209 130.027 48.525 130.348 48.934C130.666 49.344 130.905 50.11 130.729 50.53C130.565 50.917 129.811 51.245 129.305 51.264C127.012 51.354 123.34 50.164 120.842 48.486Z"
					            fill="black" />
					            <path d="M44.715 83.504C46.569 83.697 48.227 83.779 49.844 84.086C50.448 84.199 51.051 84.752 51.463 85.26C51.682 85.53 51.598 86.172 51.445 86.565C51.357 86.786 50.83 86.989 50.535 86.95C48.086 86.622 45.64 86.264 43.209 85.827C42.9 85.77 42.475 85.186 42.482 84.856C42.492 84.483 42.851 83.956 43.199 83.79C43.707 83.547 44.34 83.564 44.715 83.504Z"
					            fill="black" />
					            <path d="M55.5897 116.66C53.3967 116.053 51.4628 115.541 49.5488 114.969C49.1128 114.838 48.6798 114.555 48.3578 114.231C48.1568 114.028 48.0457 113.583 48.1197 113.307C48.1977 113.018 48.5108 112.643 48.7818 112.58C50.8228 112.109 52.7757 112.711 54.7057 113.244C55.6427 113.504 55.9177 114.604 55.5897 116.66Z"
					            fill="black" />
					            <path d="M83.0287 47.4859C83.0467 47.1309 82.9668 46.8219 83.0838 46.6949C85.1558 44.4549 87.9767 44.5519 90.6797 44.3729C90.9977 44.3519 91.5648 44.8909 91.6348 45.2459C91.6988 45.5759 91.3237 46.2729 91.0237 46.3499C88.4097 47.0229 85.7947 47.8069 83.0287 47.4859Z"
					            fill="black" />
					            <path d="M56.3609 203.174C56.5429 203.033 56.736 202.762 56.894 202.779C59.23 203.05 61.5699 203.308 63.8859 203.701C64.3899 203.785 64.909 204.31 65.226 204.767C65.425 205.054 65.263 205.593 65.263 206.29C62.474 205.733 59.9449 205.274 57.4389 204.702C56.7709 204.551 56.1149 204.105 56.3609 203.174Z"
					            fill="black" />
					            <path d="M163.09 115.295C163.227 114.869 163.236 114.533 163.373 114.469C163.785 114.278 164.238 114.151 164.687 114.073C166.531 113.753 168.373 113.399 170.228 113.194C170.734 113.137 171.431 113.415 171.785 113.786C172.129 114.147 172.299 114.839 172.246 115.354C172.219 115.625 171.553 116.032 171.17 116.036C168.824 116.061 166.477 116.016 164.133 115.917C163.762 115.9 163.406 115.492 163.09 115.295Z"
					            fill="black" />
					            <path d="M119.494 138.58C118.189 138.58 116.885 138.617 115.586 138.545C115.359 138.531 115.012 138.068 114.986 137.789C114.959 137.506 115.236 136.945 115.42 136.928C117.781 136.699 120.149 136.49 122.518 136.438C122.868 136.43 123.334 137.213 123.565 137.713C123.807 138.233 123.241 139.029 122.704 139.008C121.634 138.963 120.565 138.85 119.495 138.764C119.494 138.701 119.494 138.641 119.494 138.58Z"
					            fill="black" />
					            <path d="M56.188 218.084C56.993 217.82 57.743 217.354 58.481 217.373C60.606 217.434 62.727 217.672 64.846 217.887C65.168 217.92 65.612 218.127 65.742 218.383C65.931 218.76 65.996 219.278 65.906 219.69C65.853 219.936 65.338 220.317 65.138 220.26C62.31 219.457 59.288 219.655 56.519 218.586C56.43 218.551 56.387 218.395 56.188 218.084Z"
					            fill="black" />
					            <path d="M179.783 77.059C178.168 76.752 176.193 76.401 174.234 75.971C174.004 75.92 173.718 75.426 173.73 75.151C173.742 74.87 174.052 74.407 174.296 74.36C176.62 73.924 178.974 73.35 181.095 75.049C181.599 75.451 182.031 75.914 181.657 76.514C181.464 76.828 180.903 76.924 180.499 77.098C180.402 77.139 180.266 77.09 179.783 77.059Z"
					            fill="black" />
					            <path d="M85.7707 208.861C83.2547 208.664 81.0347 208.531 78.8297 208.283C78.3337 208.228 77.8827 207.769 77.4097 207.494C77.6267 207.115 77.7127 206.767 77.8567 206.742C80.2767 206.304 82.7107 206.025 85.1577 206.537C85.3627 206.58 85.5617 206.785 85.7007 206.963C85.8377 207.141 85.9627 207.377 85.9687 207.592C85.9747 207.918 85.8747 208.246 85.7707 208.861Z"
					            fill="black" />
					            <path d="M168.498 106.27C168.857 105.936 169.002 105.688 169.189 105.647C170.98 105.266 172.72 105.727 174.455 106.079C174.695 106.128 174.976 106.618 174.996 106.921C175.016 107.202 174.732 107.737 174.541 107.757C173.488 107.866 172.418 107.933 171.365 107.855C170.299 107.775 169.295 107.416 168.498 106.27Z"
					            fill="black" />
					            <path d="M154.52 130.07C155.01 129.617 155.329 129.088 155.596 129.113C156.969 129.238 158.338 129.47 159.688 129.759C159.92 129.808 160.268 130.388 160.194 130.577C160.048 130.948 159.678 131.434 159.337 131.489C157.637 131.768 156.18 131.111 154.52 130.07Z"
					            fill="black" />
					          </svg>
					        </div>
						';
					}			

				}

				echo '
			</div>
		';

		if ( Plugin::$instance->editor->is_edit_mode() ) { ?>

 	 		<script>
				jQuery(document).ready(function(){

					jQuery('section.elementor-element .decoration-wrapper-block:first-of-type').each(function(){
						var currentSection = jQuery(this).closest('section.elementor-element');
						jQuery(this).closest('section.elementor-element').find('.elementor-element:not(.elementor-widget-tommusrhodus-decorations-block)').addClass('layer-2');
						jQuery(this).closest('section.elementor-element').addClass('o-hidden').append(this);
						jQuery(this).siblings('.cloned-decoration-wrapper').remove();
						jQuery(this).appendTo(jQuery(this).closest('section.elementor-element') ).addClass('cloned-decoration-wrapper');
						jQuery('.cloned-decoration-wrapper').replaceWith(this);
						jQuery(currentSection).find('.decoration-wrapper-block:not(.cloned-decoration-wrapper)').empty();

					});

				});
 	 		</script>

		<?php 
		}


	}

}

// Register our new widget
Plugin::instance()->widgets_manager->register_widget_type( new Widget_TommusRhodus_Decorations_Block() );